import {nextTick, ref} from "vue";
import {geoContainer} from "./mapGEOStyle.ts";

export const containerRef = ref()
export const isAllMounted = ref(false)
export const allGraphRegister = ref<Array<{ uid: string, f: Function }>>([])

export function registerGraph(item: { uid: string, f: Function }) {
    allGraphRegister.value.push(item)
}

export const startNow = function calcGEO() {
    const rect = containerRef.value.getBoundingClientRect()
    geoContainer.value.width = rect.width
    geoContainer.value.height = rect.height
    const allStyle = window.getComputedStyle(containerRef.value)
    // @ts-ignore
    geoContainer.value.contentWidth = parseFloat(allStyle['width']) - parseFloat(allStyle['padding-left']) - parseFloat(allStyle['padding-right'])
    // @ts-ignore
    geoContainer.value.contentHeight = parseFloat(allStyle['height']) - parseFloat(allStyle['padding-top']) - parseFloat(allStyle['padding-bottom'])
    // @ts-ignore
    geoContainer.value.paddingAll = parseFloat(allStyle['paddingLeft'])
    nextTick(function () {

    }).then(function () {
        for (const item of allGraphRegister.value) {
            const chart: any = item.f()
            chart.resize();
        }
    })
}