import {VNode} from "vue";
import {ChartCompType} from "../const/chartCompType.ts";

export type BarChartOptions = {
    category: string[]
    data: number[] | { name: string, data: number[] }[],
    type: ChartCompType
};

export type PieCharOptions = {
    type: ChartCompType,
    title: string,
    radius: Array<string>,
    data:  Array<{value: number, name: string, color: string}>,
    centerText?: string | Function
}

export type GeneralChartOptions = BarChartOptions | PieCharOptions

export type ChartOptionSet = Array<GeneralChartOptions>

export type SingleLayoutConf = {
    x: number, y: number, w: number, h: number, title: string, renderTitle?: (...args: any[]) => VNode,
    chartData: ChartOptionSet
}

export type LayoutConfig = Array<SingleLayoutConf>

export type ScreenChartProps = {
    layout: LayoutConfig;
    gap?: number;
    containerPadding?: number;
    gridItemPadding?: number;
}