import {nextTick, ref} from "vue";
import {geoContainer} from "./mapGEOStyle.ts";

let ro: ResizeObserver | null = null;

export const containerRef = ref();

const startNow = function calcGEO() {
    const rect = containerRef.value.getBoundingClientRect();
    geoContainer.value.width = rect.width;
    geoContainer.value.height = rect.height;
};


export function onRemoved() {
    if (ro) {
        ro.disconnect();
        ro = null;
    }
}

export function onNew() {
    nextTick(function () {
        if (!ro) {
            ro = new ResizeObserver(function () {
                startNow();
            });
            ro.observe(containerRef.value);
            startNow();
        }
    }).then(function () {

    });
}
