import {ref} from "vue";
import {ScreenChartProps, SingleLayoutConfig} from "../types/ScreenChart.typing.ts";
import {containerRef} from "./hooksFunc.ts";

export function getContainerStyle(props: ScreenChartProps) {
    const { containerStyle} = props.options
    return {
        ...(containerStyle || {}),
        position: 'relative',
        width: 'auto',
        height: props.options.designHeight + 'px',
    }
}

export function getSingleGridStyle(props: SingleLayoutConfig, allLayout: SingleLayoutConfig[], compProps: ScreenChartProps) {
    const maxSpanColumn = allLayout.map(v => v.x + v.w).sort((a, b) => b - a)[0];
    const columnWidth = (geoContainer.value.width - (maxSpanColumn - 1) * mapWidth(compProps.options.gap)) / maxSpanColumn
    const left = `${props.x * mapWidth(compProps.options.gap) + props.x * columnWidth}px`
    const width = `${props.w * columnWidth}px`
    const top = `${mapHeight(props.y)}px`
    const height = `${mapHeight(props.h)}px`
    return {
        // @ts-ignore
        ...(props.containerStyle || {}),
        position: 'absolute',
        zIndex: 1,
        left, width, top, height
    }
}


export const geoContainer = ref({
    width: 0, height: 0, designGraphWidth: 1920, designGraphHeight: 1080,
})

export function mapWidth(designWidth: number) {
    if (!geoContainer.value.width) return designWidth
    return geoContainer.value.width / geoContainer.value.designGraphWidth * designWidth
}

export function mapWidthStyle(designWidth: number, cssName: string) {
    return {
        [cssName]: mapWidth(designWidth)
    }
}

export function mapHeight(designHeight: number) {
    return geoContainer.value.height / geoContainer.value.designGraphHeight * designHeight
}

export function mapHeightStyle(designHeight: number, cssName: string) {
    return {
        [cssName]: mapHeight(designHeight)
    }
}