import {VNode} from "vue";

export type SingleLayoutConfig = {
    x: number;
    y: number;
    w: number;
    h: number;
    component: () => VNode,
    containerClass?: string | object | Array<string>;
    containerStyle?: string | Record<string, any>;
}

export type LayoutConfig = Array<SingleLayoutConfig>

export type ScreenChartProps = {
    options: {
        designWidth: number;
        designHeight: number;
        containerClass?: string | Record<string, any> | string[];
        containerStyle?: Record<string, any>;
        layout: LayoutConfig,
        gap: number
    }
};
