import {h, ref} from "vue"
import AllDJ from "../assets/all.dj.svg?url"
import HigherDJ from "../assets/higher.dj.svg?url"
import LowerDJ from "../assets/lower.dj.svg?url"
import NonPlanDJ from "../assets/non.plan.dj.svg?url"
import NormalDJ from "../assets/normal.dj.svg?url"
import UnderGoDJ from "../assets/undergo.dj.svg?url"
import WhichNumberBox from "../widgets/WhichNumberBox.vue";

const numberWhichContainerStyle = {
    background: '#fff',
    border: '1px solid #eaecef',
    borderRadius: '8px',
}

export const numberBoxConf = ref([
    {
        imgUrl: AllDJ, title: "全部定检", value: 99
    },
    {
        imgUrl: HigherDJ, title: "高级别定检", value: 99
    },
    {
        imgUrl: LowerDJ, title: "低级别定检", value: 99
    },
    {
        imgUrl: NormalDJ, title: "正常定检", value: 99
    },
    {
        imgUrl: NonPlanDJ, title: "非计划预警", value: 99
    },
    {
        imgUrl: UnderGoDJ, title: "正在非计划", value: 99
    }
])

export const propsAll = {
    designWidth: 1920,
    designHeight: 925 + 352,
    containerClass: 'w-full',
    gap: 24,
    layout: [
        {
            x: 0,
            w: 1,
            y: 0,
            h: 151,
            containerStyle: numberWhichContainerStyle,
            component: () => h(WhichNumberBox, {ps: numberBoxConf.value[0]})
        },
        {
            x: 1,
            w: 1,
            y: 0,
            h: 151,
            containerStyle: numberWhichContainerStyle,
            component: () => h(WhichNumberBox, {ps: numberBoxConf.value[1]})
        },
        {
            x: 2,
            w: 1,
            y: 0,
            h: 151,
            containerStyle: numberWhichContainerStyle,
            component: () => h(WhichNumberBox, {ps: numberBoxConf.value[2]})
        },
        {
            x: 3,
            w: 1,
            y: 0,
            h: 151,
            containerStyle: numberWhichContainerStyle,
            component: () => h(WhichNumberBox, {ps: numberBoxConf.value[3]})
        },
        {
            x: 4,
            w: 1,
            y: 0,
            h: 151,
            containerStyle: numberWhichContainerStyle,
            component: () => h(WhichNumberBox, {ps: numberBoxConf.value[4]})
        },
        {
            x: 5,
            w: 1,
            y: 0,
            h: 151,
            containerStyle: numberWhichContainerStyle,
            component: () => h(WhichNumberBox, {ps: numberBoxConf.value[5]})
        },
    ]
}