// @ts-nocheck

import {drawCanvas} from "../objs/renderBasic";
import {ComplexDrawHandleFunc} from "../types/HandlerFunc";
import {PayloadDrawAttachment} from "../types/AttachmentSpecifics";
import {isDrawFromAction} from "../state/drawOperationType";

export const drawExpression: ComplexDrawHandleFunc = function (
    sx,
    sy,
    ex,
    ey,
    attachment: PayloadDrawAttachment) {
    if (isDrawFromAction())
        drawCanvas()
    const ctx: CanvasRenderingContext2D = attachment.ctx
    const payload = Number(attachment.payload) + 1
    const selector = `#draw-box-image.for-view-only img:nth-of-type(${payload})`
    const imageToBeDrawn = document.querySelector(selector) as HTMLImageElement
    const width = parseInt(window.getComputedStyle(imageToBeDrawn).width)
    const height = parseInt(window.getComputedStyle(imageToBeDrawn).height)
    const cx = typeof ex === 'undefined' || Number.isNaN(ex) ? sx : ex
    const cy = typeof ey === 'undefined' || Number.isNaN(ey) ? sy : ey
    ctx.drawImage(
        imageToBeDrawn,
        0,
        0,
        imageToBeDrawn.naturalWidth,
        imageToBeDrawn.naturalHeight,
        cx - width / 2,
        cy - height / 2,
        width,
        height
    )
}

