import {drawCanvas} from "../objs/renderBasic";
import {ComplexDrawHandleFunc} from "../types/HandlerFunc";
import {BaseDrawAttachment} from "../types/AttachmentSpecifics";
import {drawOperationType, isDrawFromAction} from "../state/drawOperationType";

export const drawRect: ComplexDrawHandleFunc = function (
    sx,
    sy,
    ex,
    ey,
    attachment: BaseDrawAttachment) {
    if (typeof ex === 'undefined' || typeof ey === 'undefined') return
    if (isDrawFromAction())
        drawCanvas()
    if (typeof sx === "number" && typeof sy === "number") {
        const {ctx} = attachment
        rectDrawAct(ctx, sx, sy, ex, ey)
    }
}

// @ts-ignore
export function rectDrawAct(ctx, sx, sy, ex, ey) {
    ctx.beginPath()
    ctx.rect(Math.min(sx, ex), Math.min(sy, ey), Math.abs(sx - ex), Math.abs(sy - ey))
    ctx.stroke()
}