import {drawCanvas} from "../objs/renderBasic";
import {ComplexDrawHandleFunc} from "../types/HandlerFunc";
import {ContinuousDrawAttachment} from "../types/AttachmentSpecifics";
import {isDrawFromAction} from "../state/drawOperationType";

export const drawStroke: ComplexDrawHandleFunc = function (
    sx,
    sy,
    ex,
    ey,
    attachment: ContinuousDrawAttachment) {
    if (typeof ex === 'undefined' || typeof ey === 'undefined') return
    if (isDrawFromAction())
        drawCanvas()
    const {ctx, points} = attachment
    points.push({ex, ey})
    ctx.beginPath()
    points.forEach((item, index) => {
        if (index === 0) {
            return ctx.moveTo(item.ex, item.ey)
        }
        ctx.lineTo(item.ex, item.ey)
    })
    ctx.stroke()
}