import {color, lineWidth} from "../config/canvasConfig";
import {restoreColorConfig, restoreLineWidthConfig} from "../state/operationConfigHisotry";

export const triggerRenderBasic = {
    renderDrawArgs: [] as Array<any>,
    renderResetArgs: [] as Array<any>,
    renderPlantArgs: [] as Array<any>,
    draw: 0,
    reset: 0,
    plant: 0
}

const renderBasic = function (
    ctx: CanvasRenderingContext2D,
    target: CanvasImageSource,
    sx: number,
    sy: number,
    sw: number,
    sh: number,
    dx: number,
    dy: number,
    dw: number,
    dh: number
) {
    ctx.clearRect(0, 0, dw, dh)
    ctx.drawImage(target, sx, sy, sw, sh, dx, dy, dw, dh)
}

let draw = 0
let plant = 0
let reset = 0

Object.defineProperty(triggerRenderBasic, 'reset', {
    get() {
        return reset
    },
    set(v) {
        reset = v
        // @ts-ignore
        renderBasic.apply(null, triggerRenderBasic.renderResetArgs)
    }
})

Object.defineProperty(triggerRenderBasic, 'plant', {
    get() {
        return plant
    },
    set(v) {
        plant = v
        // @ts-ignore
        renderBasic.apply(null, triggerRenderBasic.renderPlantArgs)
    }
})

Object.defineProperty(triggerRenderBasic, 'draw', {
    get() {
        return draw
    },
    set(v) {
        draw = v
        // @ts-ignore
        renderBasic.apply(null, triggerRenderBasic.renderDrawArgs)
    }
})

export function drawCanvas() {
    triggerRenderBasic.draw++
}

export function plantCanvas() {
    triggerRenderBasic.plant++
}

export function resetCanvas() {
    triggerRenderBasic.reset++
}

export function setupCanvasColor(ctx: CanvasRenderingContext2D) {
    ctx.strokeStyle = color
    ctx.fillStyle = color
    restoreColorConfig()
}

export function setupCanvasLineWidth(ctx: CanvasRenderingContext2D) {
    ctx.lineWidth = lineWidth
    restoreLineWidthConfig()
}

export function setupCanvas(ctx: CanvasRenderingContext2D) {
    setupCanvasColor(ctx)
    setupCanvasLineWidth(ctx)
}