import {COLOR_INITIAL_SELECTION_INDEX, LINE_WIDTH_INITIAL_SELECTION_INDEX} from "../config/canvasConfig";
import {initialColorIndex, picFont} from "./operationConfig";

export const setupColorConfig = function (newIndex: number) {
    initialColorIndex.value = newIndex
}

export const setupLineWidthConfig = function (newIndex: number) {
    picFont.value = newIndex
}

export const restoreLineWidthConfig = function () {
    picFont.value = LINE_WIDTH_INITIAL_SELECTION_INDEX
}

export const restoreColorConfig = function () {
    initialColorIndex.value = COLOR_INITIAL_SELECTION_INDEX
}