export interface OperationRecordTyping {
    [name: string]: RecordType
}

export interface OperationRecordAlias {
    [name: string]: string
}

export interface VectorRecord {
    sx: number,
    sy: number,
    ex: number,
    ey: number,
    payload?:any
}
export type ContinuousRecordItem = {
    ex: number,
    ey: number
}
export type RawRecordItem = {
    name: string,
    record: any
}

export type PointPayloadItem = ContinuousRecordItem & {
    payload: any
}

export type ContinuousRecord = Array<ContinuousRecordItem>

export type IndexRecord = number

export type RecordTypeOperation = number

export type GenericRecordType = VectorRecord | ContinuousRecord | IndexRecord | null | PointPayloadItem | RecordTypeOperation

export enum RecordType {
    UNSET,
    Vector,
    Continuous,
    Index,
    Immediate,
    VectorPayload,
    Revoke,
    Recover
}

export type OperationRecordInternalState = {
    operationRecordTypeSet: OperationRecordTyping
    operationRecordAlias: OperationRecordAlias
    operationRecord: string,
    rawRecord: Array<any>
}