import { defineStore } from 'pinia'
import { ContactsState, ContactsItemDto } from './types'
import { userStates } from 'AnyR/states/wsStates'
const useContactsStore = defineStore('contacts', {
    state: (): ContactsState => {
        return {
            showContactsWait: false, //是否等待接通
            chooseContactsItem: undefined, //当前选中的联系人
            allContactsList: [] //所有联系人
        }
    },

    getters: {
        //获取合并ws后的所有用户列表
        getAllOnlineContacts(state) {
            const allContactsList = [] as ContactsItemDto[]
            state.allContactsList.forEach((item1) => {
                userStates.value.onlineContacts.forEach((item2: any) => {
                    if (item1.id == item2.fromID) {
                        Object.assign(item1, item2)
                    }
                })
                allContactsList.push(item1)
            })
            return allContactsList
        },
        //获取ws的用户列表
        getOnlineContacts(state) {
            const allContactsList = [] as ContactsItemDto[]
            userStates.value.onlineContacts.forEach((item1: any) => {
                state.allContactsList.forEach((item2) => {
                    if (item1.fromID == item2.id) {
                        Object.assign(item1, item2)
                    }
                })
                allContactsList.push(item1)
            })
            return allContactsList
        }
    },

    actions: {
        //设置当前选中联系人
        setChooseUser(info: ContactsItemDto | undefined) {
            this.chooseContactsItem = info
        },
        //修改通话状态
        changeWait(val: boolean) {
            this.showContactsWait = val
        },
        //获取全部联系人
        setUserList(info: ContactsItemDto[]) {
            this.allContactsList = info
        }
    },

    persist: {
        storage: sessionStorage // 存储的类型，默认localStorage
    }
})

export default useContactsStore
