import {chatChannelState} from "../states/chatChannelStates";
import {getNowDate} from "../utils/dateRelated";

export function handleCommonCall(msgData) {
    if (msgData.msgData?.isMR) {
        chatChannelState.value.isUnderMeetingRoom = true;
        chatChannelState.value.chatRoomName = msgData.msgData.chatRoomName;
        chatChannelState.value.chatChannelId = msgData.msgData.channelId;
    }
    if (msgData.msgData?.isGroup) {
        chatChannelState.value.isUnderGroupChat = true;
        chatChannelState.value.chatRoomName = msgData.msgData.chatRoomName;
        chatChannelState.value.chatChannelId = msgData.msgData.channelId;
    }
}

function convertTypeLocally(data) {
    if (data.msgType === 'ChatTxt')
        return 'txt'
    if (['ChatImage', 'StoreScreenShareMark', 'ArchiveImage'].includes(data.msgType)) {
        return 'image'
    }
    if (data.msgType === 'ChatVideo')
        return 'video'
    if (data.msgType === 'ChatAudio')
        return 'audio'
    if (data.msgType.endsWith('.pdf')) {
        return 'pdf'
    }
    return 'file'
}

export function addMessageItemInMeeting(data) {
    const toBeMerged = {
        type: convertTypeLocally(data),
        title: data.msgData.tip,
        from_name: data.fromName ? decodeURIComponent(data.fromName)
            : data.msgData.fromName ? decodeURIComponent(data.msgData.fromName)
                : '未知用户',
        uid: data.fromID,
        record_id: data.msgData.msgId,
        url: data.msgData.tip,
        happened_time: getNowDate()
    }
    if (!chatChannelState.value.messageQueue.find(a => a.record_id === toBeMerged.record_id)) {
        chatChannelState.value.messageQueue.push(toBeMerged)
    }
}