import { createApp } from 'vue'
import App from './App.vue'
import router from './router'
import { setupPinia } from './store/'
import i18n from './locale'
import {wsShouldOpen} from "AnyR/states/coreState.js"
import AnyRemotePlugin from "AnyR/plugin"
import {getBrowserDeviceId} from "AnyR/utils/makeSID";
import useStore from "@/store/user/index"

// import directive from './directive';

// 加载Css
import './assets/css/arco.style.css'
import './assets/css/style.css'
import './assets/css/tailwind.css'
// svg插件需要的配置代码
import 'virtual:svg-icons-register'
// 加载图标
import './assets/fonts/icons/iconfont.css'

const app = createApp(App)

app.use(router)
setupPinia(app)
app.use(i18n)
app.use(AnyRemotePlugin, {
    wsOpts() {
        const user = useStore()
        return {
            url: `wss://ifar.test.com:440/wesocket?seatId=1&realUserId=${user.user_info.id}&fromID=${user.user_info.id}&username=${user.user_info.nickname}&fromName=${user.user_info.username}&deviceID=${getBrowserDeviceId()}&companyID=1&userCallGroup=1&hasMike=1&hasCamera=1&wsPwd=7ahU8LVba_mbpn_ZX6wyE&isInChat=1`,
            tabVisibleCB() {
                return true;
            },
            connectionLostCB() {
                return true;
            },
            wsSocketChannelName: `NameUserT${user.user_info.id}`,
        }
    },
    wsOpen: wsShouldOpen,
    agoraConfig: {
        notUploadLog: false,
        logLevel: 0,
        codec: 'vp8',
        mode: 'rtc',
        appId: '8db91fa9518f457e9fd489198409acf0',
        localPlayerId: 'LocalVideo',
        remotePlayerPrefix: 'RemoteVideo',
        localAp: {
            "log": {},
            "report": {},
            "accessPoints": {
                "serverList": [
                    "ifar.test.com"
                ],
                "domain": "test.com"
            }
        }
    },
    recordConfig: {
        callBackUrl: 'https://hna-platform.anyremote.cn/call/saveScreenRecordNoToken',
        fileDomain: 'https://video.anyremote.cn:444',
        recordStartUrl: 'https://ifar.test.com:3001/recorder/v1/start',
        recordStopUrl: 'https://ifar.test.com:3001/recorder/v1/stop'
    }
})
// app.use(directive);
app.mount('#app')
