/**
 * 判断两个字符串的大小，依据长度以及unicode代码来判断
 * @param str1 {String} 字符串1
 * @param str2 {String} 字符串2
 */
export function stringCompare(str1: string, str2: string) {
    if (str1.length + str2.length === 0)
        return 0
    if (str1.length === 0)
        return -1
    if (str2.length === 0)
        return 1
    const compareLength = Math.min(str1.length, str2.length)
    for (let i = 0; i < compareLength; i++) {
        const c1 = str1.codePointAt(i)
        const c2 = str2.codePointAt(i)
        // @ts-ignore
        if (c1 < c2)
            return -1
        // @ts-ignore
        if (c1 > c2)
            return 1
    }
    if (str1.length > compareLength)
        return 1
    if (str2.length > compareLength)
        return -1
    return 0
}