import {Agora} from "./agora";
import {chatChannelState, isUserHost} from "./states/chatChannelStates";
import {userStates} from "./states/wsStates";
import {generateMessageId} from "./utils/generateMessageId";
import {CallState} from "./constants/chatChannelRelated";
import {clearStateOfChatChannel} from "./functionals/chatChannel";
import {handleCommonCall} from "./functionals/callMsg";
import {addMessageItemInMeeting} from "./functionals/callMsg";
import {isCurrentUserMuted} from "./states/chatChannelStates";
import {convertObj2FU} from "./utils/cnvertObjectToFormData";
import {screenShareMetaData} from "./states/chatChannelStates";

export class AgoraHandle {
    agoraOptions = {}
    agoraApp = null
    AnyRemote = null
    recordConfig = {}
    currentRecordingData = {}

    constructor(AnyRemote) {
        this.AnyRemote = AnyRemote;
    }

    async configure(options = {
        notUploadLog: false,
        logLevel: 0,
        codec: 'vp8',
        mode: 'rtc',
        appId: '',
        localPlayerId: 'localPlayerId',
        remotePlayerPrefix: 'remotePlayerPrefix',
        localAp: null
    }, recordConfig = {
        callBackUrl: 'https://hna-platform.anyremote.cn/call/saveScreenRecordNoToken',
        fileDomain: 'https://video.anyremote.cn:444',
        recordStartUrl: 'https://video.anyremote.cn:8081/recorder/v1/start',
        recordStopUrl: 'https://video.anyremote.cn:8081/recorder/v1/stop'
    }) {
        this.recordConfig = recordConfig
        this.agoraOptions = options;
        this.agoraApp = new Agora(options)
        await this.agoraApp.preload();
    }

    onMessageHandle(msgData) {
        let {msgType, toID, fromID, fromName} = msgData
        let channelID = ''
        fromName = window.decodeURIComponent(fromName);
        let currentId = userStates.value.currentUserId
        switch (msgType) {
            case 'WannaJoin': {
                console.log('某人想要你加入频道', msgData)
                this.sendCallRequest(fromID, msgData.msgData.channelId, {
                    isMR: true, chatRoomName: msgData.msgData.chatRoomName
                })
                break;
            }
            case 'BlinkSpot': {
                console.log('有用户要求闪烁blink', msgData)
                chatChannelState.value.blinkSpotSet.push(msgData.msgData)
                break;
            }
            case 'VoiceChatOnly': {
                console.log('有用户仅语音聊天', msgData)
                if (!chatChannelState.value.voiceChatOnlySet.includes(fromID)) {
                    chatChannelState.value.voiceChatOnlySet.push(fromID)
                }
                break
            }
            case "NotVoiceChatOnly": {
                console.log('有用户取消仅语音聊天', msgData)
                if (chatChannelState.value.voiceChatOnlySet.includes(fromID)) {
                    chatChannelState.value.voiceChatOnlySet.splice(chatChannelState.value.voiceChatOnlySet.indexOf(fromID), 1)
                }
                break
            }
            case 'Recording': {
                console.log('有用户发起录制', msgData)
                if (currentId !== fromID) {
                    console.log('其他用户发起了录制', fromName)
                }
                chatChannelState.value.recordingData = {
                    id: fromID, name: fromName
                }
                break
            }
            case "NotRecording": {
                console.log('有用户取消录制', msgData)
                chatChannelState.value.recordingData = {}
                if (currentId !== fromID) {
                    console.log('其他用户取消了录制', fromName)
                }
                break;
            }
            case "CmdCall": {
                console.log('主动呼叫他人的反馈', msgData);
                if (chatChannelState.value.currentState === CallState.calling) {
                    console.log('正在通话中，无须改变状态')
                    break;
                }
                handleCommonCall(msgData, toID, fromID)
                if (!chatChannelState.value.currentChatters.includes(toID)) {
                    chatChannelState.value.currentChatters.push(toID)
                }
                if (!chatChannelState.value.currentChatters.includes(fromID)) {
                    chatChannelState.value.currentChatters.push(fromID)
                }
                chatChannelState.value.channelInitiator = toID;
                chatChannelState.value.currentState = CallState.callOut
                break
            }
            case "Call" : {
                console.log('被别人呼叫的反馈', msgData)
                if (chatChannelState.value.currentState === CallState.calling) {
                    console.log('正在通话中，无须改变状态')
                    break;
                }
                handleCommonCall(msgData)
                if (!chatChannelState.value.currentChatters.includes(fromID)) {
                    chatChannelState.value.currentChatters.push(fromID)
                }
                chatChannelState.value.channelInitiator = fromID
                toID.split(',')
                    .forEach(function (id) {
                        if (!chatChannelState.value.currentChatters.includes(id)) {
                            chatChannelState.value.currentChatters.push(id)
                        }
                    });
                if (fromID !== currentId) {
                    chatChannelState.value.currentState = CallState.callIn
                } else {
                    chatChannelState.value.currentState = CallState.callOut
                }
                if (window.Notification) {
                    window.Notification.requestPermission()
                        .then(function (result) {
                            if (result === 'granted') {
                                const a = new window.Notification(`收到${msgData.fromName}呼叫请求`, {
                                    body: '收到呼叫请求，点击回到标签页',
                                });
                                a.addEventListener('click', function () {
                                    a.close();
                                    window.focus()
                                })
                            }
                        })
                }
                break;
            }
            case 'CmdHangup': {
                console.log('收到服务器挂断指令', msgData)
                if (currentId === toID) {
                    this.agoraApp.leave()
                        .then(function () {
                            clearStateOfChatChannel()
                        })
                }
                break
            }
            case "CmdCancelCall" : {
                console.log('呼叫方取消呼叫', msgData)
                if (currentId === toID) {
                    if (chatChannelState.value.currentState === CallState.callOut) {
                        this.agoraApp.leave()
                            .then(function () {
                                clearStateOfChatChannel()
                            })
                        break
                    }
                    if (chatChannelState.value.currentState === CallState.calling) {
                        fromID.split(',')
                            .forEach(function (id) {
                                chatChannelState.value.currentChatters = chatChannelState.value.currentChatters.filter(function (item) {
                                    return item !== id;
                                })
                            })
                    }
                }
                break
            }
            case "CmdConnect" : {
                console.log('收到服务器主动连接指令', msgData)
                channelID = msgData.msgData.channelID;
                chatChannelState.value.chatChannelId = channelID;
                chatChannelState.value.rtcToken = msgData.msgData.rtcToken
                chatChannelState.value.currentState = CallState.calling
                break
            }
            case 'CmdRefuse' : {
                console.log('对方拒接了', msgData)
                const targetPersonnel = userStates.value.onlineContacts.find(function (q) {
                    return q.fromID === fromID
                })
                if (targetPersonnel) {
                    console.log('有人拒绝了你的对话邀请', targetPersonnel.fromName, targetPersonnel)
                }
                chatChannelState.value.currentChatters = chatChannelState.value.currentChatters.filter(function (item) {
                    return item !== fromID;
                })
                console.log('剩下来的会议参会人', chatChannelState.value.currentChatters)
                if (chatChannelState.value.currentChatters.length === 1 && chatChannelState.value.currentChatters[0] === userStates.value.currentUserId) {
                    this.AnyRemote.sendWSFromCall('0', 'CancelCall')
                }
                break
            }
            case 'CmdLeave': {
                console.log('某人离开了', fromID)
                if (toID === userStates.value.currentUserId) {
                    console.log('主持人提出了你！');
                    this.agoraApp.leave()
                        .then(function () {
                            clearStateOfChatChannel()
                        })
                    break
                }
                const targetPersonnel = userStates.value.onlineContacts.find(function (q) {
                    return q.fromID === fromID
                })
                if (targetPersonnel) {
                    console.log('有人退出了对话', targetPersonnel.fromName, targetPersonnel)
                }
                chatChannelState.value.currentChatters = chatChannelState.value.currentChatters.filter(function (item) {
                    return item !== fromID;
                })
                break
            }
            case 'CmdEndMeeting' : {
                console.log('主持人要求结束通话', msgData)
                if (!isUserHost.value) {
                    console.log('主持人结束了通话，之后可以再次发起')
                }
                this.agoraApp.leave()
                    .then(function () {
                        clearStateOfChatChannel()
                    })
                break
            }
            case "CmdKickOut" : {
                console.log('主持人将某人提出房间', msgData);
                const targetPersonnel = userStates.value.onlineContacts.find(function (q) {
                    return q.fromID === fromID
                })
                chatChannelState.value.currentChatters = chatChannelState.value.currentChatters.filter(function (item) {
                    return item !== msgData.msgData.toID
                })
                if (msgData.msgData.toID !== currentId) {
                    console.log(`主持人踢出了${targetPersonnel.fromName}`)
                } else {
                    console.log('主持人踢出了你')
                }
                break;
            }
            case "CmdMuteAll": {
                console.log('主持人要求所有人静音', msgData)
                this.agoraApp.currentUserToggleMute(true)
                chatChannelState.value.currentChatters.forEach(function (id) {
                    if (!chatChannelState.value.mutedUserIdSet.includes(id)) {
                        chatChannelState.value.mutedUserIdSet.push(id)
                    }
                })
                break
            }
            case 'MuteSelf':
            case 'CmdMuteSelf': {
                console.log('某人静音了自己', msgData)
                chatChannelState.value.mutedUserIdSet.push(fromID)
                if (fromID === currentId) {
                    this.agoraApp.currentUserToggleMute(true)
                }
                break
            }
            case 'ScreenShareStart': {
                console.log('某人开始发起屏幕共享', msgData)
                chatChannelState.value.screenShareId = fromID
                break
            }
            case 'ScreenShareEnd': {
                console.log('某人停止了屏幕共享', msgData)
                chatChannelState.value.screenShareId = ''
                chatChannelState.value.screenCaptureShotURL = ''
                break
            }
            case 'MarkBg': {
                console.log('某人要求截图', msgData)
                chatChannelState.value.screenshotInitiatorId = msgData.msgData.initId;
                chatChannelState.value.screenshotURL = msgData.msgData.url;
                break
            }
            case 'MarkImage': {
                console.log('接收到截图资料点', msgData)
                if (currentId !== fromID) {
                    chatChannelState.value.screenshotRecord = {
                        ...chatChannelState.value.screenshotRecord,
                        [fromID]: msgData.msgData.records
                    }
                }
                break
            }
            case 'CloseMark': {
                console.log('标注者要求退出', msgData)
                chatChannelState.value.screenshotInitiatorId = ''
                chatChannelState.value.screenshotRecord = {}
                chatChannelState.value.screenshotURL = ''
                break
            }
            case 'EndScreenShareMark': {
                console.log('屏幕共享要求退出', msgData)
                chatChannelState.value.screenCaptureRecord = {}
                chatChannelState.value.screenCaptureShotURL = ''
                break
            }
            case 'StartScreenShareMark': {
                console.log('有用户发起了屏幕共享截图', msgData)
                chatChannelState.value.screenCaptureShotURL = msgData.msgData.url;
                break
            }
            case 'ChatAudio':
            case 'ChatFile':
            case 'ChatTxt':
            case 'ChatVideo':
            case 'ArchiveImage':
            case 'StoreScreenShareMark':
            case 'ChatImage':
            {
                console.log('收到ws消息点', msgData)
                addMessageItemInMeeting(msgData)
                break
            }
            case 'ContinueScreenShareMark': {
                if (fromID === toID) {
                    break
                }
                console.log('用户发送屏幕共享截图标记点', msgData)
                if (currentId !== fromID) {
                    chatChannelState.value.screenCaptureRecord = {
                        ...chatChannelState.value.screenCaptureRecord,
                        [fromID]: msgData.msgData.records
                    }
                }
                break;
            }
            case 'UnMuteSelf':
            case 'CmdUnMuteSelf': {
                console.log('某人取消静音', fromID)
                if (fromID === currentId) {
                    this.agoraApp.currentUserToggleMute(false)
                }
                chatChannelState.value.mutedUserIdSet = chatChannelState.value.mutedUserIdSet.filter(function (q) {
                    return q !== fromID
                })
                break;
            }
            case 'CmdMute': {
                console.log('主持人要求静音', msgData);
                if (fromID === currentId) {
                    this.agoraApp.currentUserToggleMute(true)
                }
                if (!chatChannelState.value.mutedUserIdSet.includes(fromID)) {
                    chatChannelState.value.mutedUserIdSet.push(fromID)
                }
                break
            }
            default:
                break;
        }
    }

    sendCallRequest(toID) {
        const channelId = chatChannelState.value.chatChannelId
        this.AnyRemote.sendWSFromCall(toID, 'Call', undefined, channelId)
    }

    async forceReplay(id) {
        await this.agoraApp.forceReplay(id, `${this.agoraOptions.remotePlayerPrefix}${id}`)
    }

    forceUpdateOnlineUsers() {
        this.agoraApp.sendWSFromCall('0', 'GetCompanyUserList');
    }

    async joinChatRoom() {
        await this.agoraApp.join(
            chatChannelState.value.chatChannelId,
            '',
            Number(userStates.value.currentUserId)
        )
    }

    sendTextInChatRoom(text) {
        this.AnyRemote.sendWSFromCall(
            '-2',
            'ChatTxt',
            {
                tip: text,
                quoteId: '',
                channelID: chatChannelState.value.chatChannelId,
                fromName: userStates.value.currentUserName,
                msgId: generateMessageId()
            }
        )
    }

    sendImage(data) {
        const channelID = chatChannelState.value.chatChannelId;
        const fromName = userStates.value.currentUserName
        this.AnyRemote.sendWSFromCall(
            '-2',
            'ChatImage', {
                msgId: generateMessageId(),
                quoteId: "",
                channelID,
                fromName,
                tip: {
                    fileUrl: data.fileUrl,
                    fileName: data.fileName,
                    fileSize: data.fileSize,
                    fileType: "image"
                }
            }
        )
    }

    sendFile(data) {
        const channelID = chatChannelState.value.chatChannelId;
        const fromName = userStates.value.currentUserName
        this.AnyRemote.sendWSFromCall(
            '-2',
            'ChatFile', {
                msgId: generateMessageId(),
                quoteId: "",
                channelID,
                fromName,
                tip: {
                    fileUrl: data.fileUrl,
                    fileName: data.fileName,
                    fileSize: data.fileSize,
                    fileType: "file"
                }
            }
        )
    }

    sendVideo(data, fileType = 'video') {
        const channelID = chatChannelState.value.chatChannelId;
        const fromName = userStates.value.currentUserName
        const md = {
            msgId: generateMessageId(),
            quoteId: "",
            channelID,
            fromName,
            tip: {
                fileUrl: data.fileUrl,
                fileName: data.fileName,
                fileSize: data.fileSize,
                fileType
            }
        }
        this.AnyRemote.sendWSFromCall(
            '-2',
            'ChatVideo', md
        )
    }

    endMark(cancelType = 'video') {
        if (cancelType === 'video') {
            this.AnyRemote.sendWSFromCall('-2', 'CloseMark')
        } else {
            this.AnyRemote.sendWSFromCall('-2', 'EndScreenShareMark')
        }
    }

    startMark(url, type = 'video') {
        this.AnyRemote.sendWSFromCall(
            '-2',
            type === 'video' ? 'MarkBg' : "StartScreenShareMark",
            {
                url, initId: userStates.value.currentUserId
            }
        )
    }

    continueMark(records, type = 'video') {
        this.AnyRemote.sendWSFromCall(
            '-2',
            type === 'video' ? 'MarkImage' : "ContinueScreenShareMark",
            {
                records
            }
        )
    }

    cancelCurrentCall() {
        const toBeSentUserId = chatChannelState.value.currentChatters.filter(a => a !== userStates.value.currentUserId);
        this.AnyRemote.sendWSFromCall(toBeSentUserId.join(','), 'CancelCall')
    }

    cancelExactCall(id) {
        this.AnyRemote.sendWSFromCall(id.toString(), 'CancelCall')
    }

    refuseCurrentCall() {
        const toID = chatChannelState.value.currentChatters[0]
        this.AnyRemote.sendWSFromCall(toID.toString(), 'Refuse')
    }

    endCurrentCall() {
        this.AnyRemote.sendWSFromCall('0', 'EndMeeting')
    }

    hangUpCurrentCall() {
        this.AnyRemote.sendWSFromCall('0', 'Hangup')
    }

    acceptCurrentCall() {
        const [toId, rtcToken, channelID] = [
            chatChannelState.value.currentChatters[0], chatChannelState.value.rtcToken, chatChannelState.value.chatChannelId
        ]
        this.AnyRemote.sendWSFromCall(toId, 'Connect', {rtcToken, channelID})
    }

    toggleMuteSelf() {
        const v = !isCurrentUserMuted.value
        this.AnyRemote.sendWSFromCall(
            '-2',
            v ? 'MuteSelf' : "UnMuteSelf"
        )
    }

    toggleVoiceChatOnly(v) {
        this.AnyRemote.sendWSFromCall(
            '-2',
            v ? "VoiceChatOnly" : "NotVoiceChatOnly"
        )
    }

    muteAllUser() {
        this.AnyRemote.sendWSFromCall(
            '-2',
            'MuteAll'
        )
    }

    muteTargetUser(pid) {
        this.AnyRemote.sendWSFromCall(pid.toString(), 'Mute')
    }

    kickCurrentUser(toId) {
        this.AnyRemote.sendWSFromCall(toId.toString(), 'KickOut', {toID: toId})
    }

    async recordCurrent() {
        const channel_id = chatChannelState.value.chatChannelId
        const uid_screen = userStates.value.currentUserId
        const record_mode = '1'
        const reqData = {
            appid: this.agoraOptions.appId,
            channel_id,
            uid_screen,
            callback_url: this.recordConfig.callBackUrl,
            record_mode,
            file_domain: this.recordConfig.fileDomain
        };
        this.currentRecordingData = {
            channel_id, uid_screen, record_mode
        }
        const resp = await window.fetch(
            this.recordConfig.recordStartUrl, {
                method: 'post',
                headers: {
                    'content-type': "application/x-www-form-urlencoded"
                },
                body: convertObj2FU(reqData)
            }
        )
        const res = await resp.json()
        console.log('开始录制返回结果', res)
        if (res.success) {
            chatChannelState.value.recordSid = res.data.sid;
            this.AnyRemote.sendWSFromCall('-2', 'Recording')
            return true
        }
        return false
    }

    async stopRecordCurrent() {
        const {channel_id, uid_screen, record_mode} = this.currentRecordingData
        const reqData = {
            appid: this.agoraOptions.appId,
            channel_id,
            uid_screen,
            callback_url: this.recordConfig.callBackUrl,
            record_mode,
            file_domain: this.recordConfig.fileDomain
        };
        const hautResp = await window.fetch(
            this.recordConfig.recordStopUrl,
            {
                method: 'post',
                headers: {
                    'content-type': "application/x-www-form-urlencoded"
                },
                body: convertObj2FU(reqData)
            }
        );
        const resp = await hautResp.json()
        console.log('结束录制返回结果', resp)
        this.AnyRemote.sendWSFromCall('-2', 'NotRecording')
        if (resp.success) {
            return resp.data
        }
        return false
    }

    async archiveMark(fileData, type = 'video') {
        this.AnyRemote.sendWSFromCall(
            '-2',
            type === 'video' ? 'ArchiveImage' : "StoreScreenShareMark",
            {
                msgId: generateMessageId(),
                tip: {
                    fileType: 'image',
                    fileUrl: fileData.fileUrl,
                    fileName: `截图标注-${new Date().toLocaleString()}`,
                    fileSize: fileData.fileSize
                },
                quoteId: "",
                channelID: chatChannelState.value.chatChannelId,
                fromName: userStates.value.currentUserName
            }
        )
    }

    screenShareHandle() {
        const v = !screenShareMetaData.value.byCurrentUser
        this.AnyRemote.sendWSFromCall(
            '-2',
            v ? "ScreenShareStart" : "ScreenShareEnd"
        )
    }

    sendBlinkSpot(v) {
        this.AnyRemote.sendWSFromCall(
            '-2',
            'BlinkSpot',
            v
        )
    }
}