export class SocketBroadcaster {

    bc = null;
    msgListener = [];

    constructor(name) {
        this.bc = new BroadcastChannel(name);
        this.bc.onmessage = (e) => {
            for (const f of this.msgListener) {
                f(e.data);
            }
        }
        window.addEventListener('beforeunload', function () {
            this.destroy();
        }.bind(this))
    }

    addListener(f) {
        if (!this.msgListener.includes(f))
            this.msgListener.push(f)
    }

    removeListener(f) {
        this.msgListener = this.msgListener.filter((f2) => f2 !== f)
    }

    send(msg) {
        if (this.bc) {
            this.bc.postMessage(JSON.stringify(msg))
        }
    }

    destroy() {
        if (this.bc) {
            this.bc.close()
            this.bc = null;
            this.msgListener = [];
        }
    }

}