import {WSInt} from "./ws";
import {AgoraHandle} from "./agoraHandle";
import {userStates} from "./states/wsStates";

export class AnyRemote {

    wsInt = null
    agora = null

    configureWS(url, tabVisibleCB = () => true, connectionLostCB = () => true, wsSocketChannelName = '') {
        this.wsInt = new WSInt(url, this.onMessageGeneral.bind(this), tabVisibleCB, connectionLostCB, wsSocketChannelName)
        this.wsInt.connect()
    }

    sendWSFromCall(toID, msgType, msgData, channelID) {
        this.wsInt.send({
            fromID: userStates.value.currentUserId,
            fromName: userStates.value.currentUserName,
            msgData,
            toID,
            channelID,
            msgType
        })
    }

    /**
     * 配置Agora
     * @param options
     * @param recordConfig
     * @return {Promise<void>}
     */
    async configureAgora(options = {
        notUploadLog: false,
        logLevel: 0,
        codec: 'vp8',
        mode: 'rtc',
        appId: '',
        localPlayerId: 'localPlayerId',
        remotePlayerPrefix: 'remotePlayerPrefix',
        localAp: null
    }, recordConfig = {
        callBackUrl: 'https://hna-platform.anyremote.cn/call/saveScreenRecordNoToken',
        fileDomain: 'https://video.anyremote.cn:444',
        recordStartUrl: 'https://video.anyremote.cn:8081/recorder/v1/start',
        recordStopUrl: 'https://video.anyremote.cn:8081/recorder/v1/stop'
    }) {
        this.agora = new AgoraHandle(this);
        await this.agora.configure(options, recordConfig)
    }

    onMessageGeneral(data) {
        let {msgType} = data
        if (msgType === 'ForceUpdateOnlineUsers') {
            console.log('需要主动拉取在线用户列表', data)
            this.sendWSFromCall('0', 'GetCompanyUserList')
        } else if (msgType === 'GetCompanyUserList' || msgType === 'CmdUpdateUserList') {
            console.log('在线用户列表更新', data)
            userStates.value.onlineContacts = data.msgData
        }
        if (this.agora) {
            this.agora.onMessageHandle(data)
        }
    }

}

export function useAnyR() {
    return inject("AnyR")
}