import {computed, ref} from "vue"
import {WebRTCNetworkQualityLevelCN} from "AnyR/constants/webrtcRelated.js";

export const webrtcStates = ref({
    cameraDeviceSet: [],
    networkQuality: {
        up: 0, down: 0
    },
    currentUsingCameraName: "",
    isCameraAttached: false,
    isMicroAttached: false,
})

export const NetworkQualityLevel = computed(function () {
    const min = Math.min(webrtcStates.value.networkQuality.down, webrtcStates.value.networkQuality.down);
    return {
        level: min, label: WebRTCNetworkQualityLevelCN[min]
    };
})