import {SocketBroadcaster} from "../bc";
import {
    currentTabIdNameGet,
    currentWSTabReceive,
    otherTabClose,
    otherTabSend,
    wsAnswerForMain,
    wsConnected,
    wsOtherLoginNow,
    wsQueryForMain,
    wsTabCloseSet,
} from "../ws/eventTypes";
import {userStates} from "../states/wsStates";

export class WSInt {
    static BCName = 'WSInt'
    static subWindowKeyIdentifierInWindow = '$SubWSInt'
    scName = ''
    ws = null
    url = ''
    bc = null
    allWSNameSet = []
    timeIndex = Number.NEGATIVE_INFINITY
    countDownTimerForQueryWSOwnershipTag = 0
    isWSTabShifting = false
    bufferedDataWhenShift = []
    wsCallQueuedData = []
    currentServerHeartReceivedTime = 0
    heartLogGroup = []
    isConnectionFailed = false;
    connectionFailedContinuousTimes = 0
    heartFailedCountDownMutex = 3
    heartTimer = 0
    nextHeartNotReceiveTimer = 0;
    enforceReconnect = false
    isReOpen = false
    lastNameBeforeCurrentTabBeingMainTab = ''

    constructor(url,
                onMessageFunc,
                tabVisibleCB = () => true,
                connectionLostCB = () => true,
                wsSocketChannelName = ''
    ) {
        this.url = url;
        this.onMessageFunc = onMessageFunc;
        this.whenTabVisible = tabVisibleCB
        this.connectionLostCB = connectionLostCB
        this.scName = wsSocketChannelName || WSInt.BCName
        this.#setupSBC();
        window.addEventListener('beforeunload', this.#unloadHandle.bind(this));
        window.addEventListener('online', () => {
            console.log('重新连接网络')
            if (!this.currentTabWSName && this.url) {
                this.connect()
            }
        })
        window.addEventListener('offline', () => {
            if (!this.currentTabWSName) {
                this.close(true)
            }
        })
        document.addEventListener('visibilitychange', () => {
            if (this.currentTabWSName)
                return;
            if (document.visibilityState === 'visible') {
                const nowTime = Date.now()
                const timeInterval = nowTime - this.currentServerHeartReceivedTime
                console.log('上一次心跳判断', this.currentServerHeartReceivedTime, timeInterval)
                const shouldPersist = this.whenTabVisible()
                if (this.isConnectionFailed && this.connectionFailedContinuousTimes === 5) {
                    console.log('连续5次没有成功连接，挂断ws')
                    this.ws?.close()
                    this.ws = null;
                    return;
                }
                if (this.currentServerHeartReceivedTime !== 0 && shouldPersist && timeInterval > 7000 && this.heartFailedCountDownMutex === 0) {
                    console.log('没有连续收到心跳，在页面被激活情况下，应当强制重连')
                    this.enforceReconnect = true;
                    this.#persistReopen()
                }
            }
        })
        this.connect();
    }

    get currentTabWSName() {
        return window.sessionStorage[WSInt.subWindowKeyIdentifierInWindow]
    }

    set currentTabWSName(v) {
        window.sessionStorage[WSInt.subWindowKeyIdentifierInWindow] = v;
    }

    connectionLostCB = () => true

    whenTabVisible = () => {
        return true
    }

    onMessageFunc = () => {
    }

    #reSetUpWS() {
        this.lastNameBeforeCurrentTabBeingMainTab = this.currentTabWSName
        this.currentTabWSName = '';
        this.connect()
    }

    #setupSBC() {
        this.bc = new SocketBroadcaster(this.scName);
        this.bc.addListener((msg) => {
            const v = JSON.parse(msg);
            if (v.type === wsConnected) {
                const {data: name} = v;
                if (name) {
                    this.allWSNameSet = this.allWSNameSet.filter(a => a !== name);
                }
            } else if (v.type === currentTabIdNameGet) {
                this.allWSNameSet.push(v.data);
                this.allWSNameSet.sort(function (a, q) {
                    const at = a.split('-')[0] * 1;
                    const qt = q.split('-')[0] * 1;
                    if (qt && at) {
                        return at - qt;
                    }
                    return a - q;
                });
                if (!window[WSInt.subWindowKeyIdentifierInWindow]) {
                    this.bc.send({
                        type: wsAnswerForMain
                    })
                }
                if (this.timeIndex === Number.NEGATIVE_INFINITY && this.currentTabWSName) {
                    const currentTime = Number(this.currentTabWSName.split('-')[0]);
                    this.timeIndex = this.allWSNameSet.find(a => {
                        return currentTime > Number(a.split('-')[0]);
                    });
                    clearTimeout(this.countDownTimerForQueryWSOwnershipTag)
                    this.countDownTimerForQueryWSOwnershipTag = setTimeout(() => {
                        this.bc.send({
                            type: wsAnswerForMain
                        })
                        this.#reSetUpWS()
                    }, 5000 + this.timeIndex * 1000);
                }
            } else if (v.type === otherTabClose) {
                const {data: name} = v;
                if (name) {
                    this.allWSNameSet.splice(this.allWSNameSet.indexOf(name), 1);
                    this.allWSNameSet.sort(function (a, q) {
                        const at = a.split('-')[0] * 1;
                        const qt = q.split('-')[0] * 1;
                        if (qt && at) {
                            return at - qt;
                        }
                        return a - q;
                    });
                }
            } else if (v.type === wsQueryForMain) {
                if (!this.currentTabWSName) {
                    this.bc.send({
                        type: wsAnswerForMain
                    })
                }
            } else if (v.type === wsAnswerForMain) {
                clearTimeout(this.countDownTimerForQueryWSOwnershipTag)
            }
            if (this.currentTabWSName) {
                if (this.isWSTabShifting && v.type === otherTabSend) {
                    this.bufferedDataWhenShift.push(v.data)
                }
                if (v.type === currentWSTabReceive) {

                } else if (v.type === wsTabCloseSet) {
                    this.isWSTabShifting = true;
                    const allNamesP = v.data;
                    if (allNamesP[0] && this.currentTabWSName === allNamesP[0]) {
                        this.#reSetUpWS()
                    }
                } else if (v.type === wsOtherLoginNow) {
                    location.href = ''
                    window.close()
                }
            } else {
                if (this.ws instanceof WebSocket) {
                    if (v.type === otherTabSend) {
                        console.log('其他标签页代理发送消息', v)
                        this.send(v.data)
                    }
                }
            }
        });
    }

    #heartAction() {
        console.log('开始发送心跳')
        clearTimeout(this.nextHeartNotReceiveTimer)
        const {currentUserId, currentUserName} = userStates.value
        this.send({
            fromID: currentUserId, fromName: currentUserName,
            toID: '0', msgType: 'Heart'
        })
        this.heartLogGroup.length = 0;
        this.heartLogGroup.push('客户端发送心跳')
        console.log('客户端发送心跳完毕')
        this.nextHeartNotReceiveTimer = setTimeout(() => {
            this.heartFailedCountDownMutex--;
            if (this.heartFailedCountDownMutex > 0) {
                return this.#heartAction()
            }
            if (this.ws instanceof WebSocket) {
                console.log('连续三次没有收到服务器心跳，准备重新连接！');
                this.isConnectionFailed = true;
                this.connectionFailedContinuousTimes++;
                this.enforceReconnect = true;
                this.close()
                this.#persistReopen()
            }
        }, 7000)
    }

    #sendHeart(initial = false) {
        if (initial) {
            this.#heartAction()
        } else {
            clearTimeout(this.heartTimer);
            this.heartTimer = setTimeout(() => {
                this.#heartAction()
            }, 5000)
        }
    }

    send(data) {
        console.log('待发送的ws消息组', data)
        if (this.currentTabWSName) {
            console.log('当前为子窗口，需要代理发送')
            this.bc.send({
                type: otherTabSend, data
            })
            return
        }
        if (this.ws instanceof WebSocket) {
            console.log('ws已经不为空，准备发送')
            if (this.ws.readyState !== 1) {
                console.log('ws没有被打开，拉入发送缓存')
                this.wsCallQueuedData.push(data)
                return;
            }
            console.log('ws已经连接，开始清空所有缓存信息')
            if (this.wsCallQueuedData.length) {
                this.wsCallQueuedData.forEach((data) => {
                    this.ws.send(JSON.stringify(data));
                })
                this.wsCallQueuedData.length = 0
            }
            this.ws.send(JSON.stringify(data));
            console.log('发送ws消息完毕')
        } else {
            console.log('ws为空，需要将其推入缓存')
            this.wsCallQueuedData.push(data)
        }
    }

    close(noAutoReconnect = false) {
        console.log('关闭ws中，是否需要重新连接', noAutoReconnect)
        this.heartFailedCountDownMutex = 3;
        if (this.currentTabWSName)
            return;
        window.removeEventListener('unload', this.#unloadHandle)
        if (noAutoReconnect) {
            console.log('不需要重新自动连接！', noAutoReconnect)
            this.enforceReconnect = false
            clearTimeout(this.nextHeartNotReceiveTimer);
            this.currentServerHeartReceivedTime = 0;
        }
        console.log('关闭ws中')
        if (this.ws instanceof WebSocket) {
            this.ws.close()
            this.ws = null
            console.log('ws已经关闭！')
        }
    }

    #persistReopen() {
        console.log('进入重新连接ws的判断')
        clearTimeout(this.nextHeartNotReceiveTimer)
        this.currentServerHeartReceivedTime = 0
        if (!this.connectionLostCB()) {
            this.enforceReconnect = false
        }
        if (this.isConnectionFailed && this.connectionFailedContinuousTimes === 5) {
            console.log('已经连续5次无法成功连接ws，彻底摆烂！')
            this.ws?.close()
            this.ws = null
            return;
        }
        if (this.enforceReconnect) {
            console.log('需要重连，做出判断开始')
            this.isReOpen = true;
            this.connect();
        }
    }

    #unloadHandle() {
        if (this.ws instanceof WebSocket) {
            this.bc.send({
                type: wsTabCloseSet,
                data: this.allWSNameSet
            })
            if (this.allWSNameSet.length > 0) {
                this.currentTabWSName = `${Date.now()}-Browser`
            } else {
                this.bc.send({
                    type: wsOtherLoginNow
                })
            }
        } else {
            this.bc.send({
                type: otherTabClose,
                data: this.currentTabWSName
            })
        }
    }

    connect() {
        console.log('开始连接ws');
        clearTimeout(this.countDownTimerForQueryWSOwnershipTag);
        if (this.ws !== null && !this.isReOpen) {
            console.log('ws已经连接！')
        } else {
            if (this.currentTabWSName) {
                console.log('当前标签页为子页面，无须连接！');
                this.bc.send({
                    type: currentTabIdNameGet,
                    data: this.currentTabWSName
                })
                this.bc.send({
                    type: wsQueryForMain,
                    data: this.currentTabWSName
                })
                this.countDownTimerForQueryWSOwnershipTag = setTimeout(() => {
                    this.bc.send({
                        type: wsAnswerForMain
                    })
                    this.#reSetUpWS()
                }, 5000)
                return;
            }
            console.log('非子标签页，需要连接ws')
            this.ws = new WebSocket(this.url)
            console.log('实例化ws完毕')
            this.ws.addEventListener('message', (e) => {
                const dataParsed = JSON.parse(e.data)
                this.bc.send({
                    type: currentWSTabReceive, data: dataParsed
                })
                if (dataParsed.msgType === 'Heart') {
                    this.currentServerHeartReceivedTime = Date.now();
                    this.heartLogGroup.push('收到服务器心跳');
                    console.log(this.heartLogGroup.join(' <==> '))
                    this.isConnectionFailed = false
                    this.connectionFailedContinuousTimes = 0;
                    this.heartFailedCountDownMutex = 3;
                    this.#sendHeart()
                } else {
                    this.onMessageFunc(dataParsed)
                }
            })
            this.ws.addEventListener('open', () => {
                console.log('ws连接成功！')
                if (this.isReOpen) {
                    console.log('ws重新连接成功')
                }
                this.heartFailedCountDownMutex = 3;
                this.isReOpen = false
                this.isConnectionFailed = false;
                this.connectionFailedContinuousTimes = 0;
                this.enforceReconnect = false
                clearTimeout(this.nextHeartNotReceiveTimer)
                this.#sendHeart(true)
                if (this.lastNameBeforeCurrentTabBeingMainTab) {
                    this.bc.send({
                        type: wsConnected,
                        data: this.lastNameBeforeCurrentTabBeingMainTab
                    })
                    this.lastNameBeforeCurrentTabBeingMainTab = ''
                }
                if (this.isWSTabShifting) {
                    this.isWSTabShifting = FileSystemSyncAccessHandle
                    for (const data of this.bufferedDataWhenShift) {
                        this.send(data)
                    }
                    this.bufferedDataWhenShift = []
                }
            });
            this.ws.addEventListener('close', (e) => {
                console.log('ws连接关闭！', e, '是否需要重新连接？', this.enforceReconnect)
            })
            this.ws.addEventListener('error', (e) => {
                console.log('ws连接错误！', e, '是否需要重新连接？', this.enforceReconnect)
            })
        }
    }

}