import { computed } from 'vue'
import { useI18n } from 'vue-i18n'
import { Message } from '@arco-design/web-vue'

export default function useLocale() {
    const i18 = useI18n()
    const currentLocale = computed(() => {
        return i18.locale.value
    })
    const changeLocale = (value: string) => {
        if (i18.locale.value === value) {
            return
        }
        i18.locale.value = value
        localStorage.setItem('arco-locale', value)
        Message.success(i18.t('action.locale'))
    }
    return {
        currentLocale,
        changeLocale
    }
}
