export let socketChannelBroadcast: BroadcastChannel | null

const msgListener = [] as Function[]

export function removeListenerOfSCB(f: Function) {
    const index = msgListener.findIndex(a => a === f);
    if (index > -1) {
        msgListener.splice(index, 1)
    }
}

export function setupSCB(name: string) {
    if (!socketChannelBroadcast) {
        socketChannelBroadcast = new BroadcastChannel(name);
        socketChannelBroadcast.onmessage = function ($e) {
            for (const f of msgListener) {
                f.call(null, $e.data)
            }
        }
    }
}

export function pushListenerSCB(f: Function) {
    if (!msgListener.includes(f)) {
        msgListener.push(f);
    }
}

export function pushMsgSCB(msg: any) {
    if (socketChannelBroadcast) {
        socketChannelBroadcast.postMessage(JSON.stringify(msg))
    }
}

export function destroySCB() {
    if (socketChannelBroadcast) {
        socketChannelBroadcast = null;
        msgListener.length = 0;
    }
}