import { createRouter, createWebHashHistory, RouteRecordRaw } from 'vue-router'
import remote from './remote'

const routes: Array<RouteRecordRaw> = [
    {
        path: '/',
        component: () => import(/* webpackChunkName: "Layout" */ '@/views/layout/index.vue'),
        name: 'Layout',
        redirect: { name: 'Contacts' },
        children: [{ ...remote }]
    },
    {
        path: '/login',
        component: () => import(/* webpackChunkName: "Login" */ '@/views/login/index.vue'),
        name: 'Login',
        meta: { title: '登录' },
        children: []
    },
    {
        path: '/404',
        name: 'Error404',
        component: () => import(/* webpackChunkName: "Error404" */ '@/views/error/index.vue'),
        meta: { power: true, title: '404' }
    },
    {
        path: '/:pathMatch(.*)*',
        component: () => import(/* webpackChunkName: "Error404" */ '@/views/error/index.vue'),
        meta: { power: true, title: '404' }
    }
]

const router = createRouter({
    history: createWebHashHistory(),
    routes
})

export default router
