import { defineStore } from 'pinia'
import { AppState } from './types'
import { changeArcoTheme } from '@/configs/arco.ui.config'
import { changeTailwindTheme } from '@/configs/tailwind.ui.config'

const useAppStore = defineStore('app', {
    state: (): AppState => {
        return {
            theme: 'light',
            count: 0,
            loadText: '加载中...'
        }
    },

    getters: {
        //是否展示全屏加载
        showLoading(state) {
            if (state.count > 0) {
                return true
            } else {
                return false
            }
        }
    },

    actions: {
        changeTheme(themeName: string) {
            this.theme = 'dark'
            changeArcoTheme(themeName)
            changeTailwindTheme(themeName)
        }
    },

    persist: false
})

export default useAppStore
