import { defineStore } from 'pinia'
import type { UserState, UserInfo } from './types'
import useAppStore from '@/store/app/index'
import { wsShouldOpen } from 'AnyR/states/coreState.js'

const useContactsStore = defineStore('user', {
    state: (): UserState => {
        return {
            token: '',
            user_info: {
                id: '',
                username: '',
                nickname: '',
                status: 0,
                token: '',
                tokenHead: ' ',
                videoGroup: 0,
                autoRecord: false
            }
        }
    },

    getters: {},

    actions: {
        //用户登录
        setUserInfo(res: UserInfo) {
            this.token = res.token
            this.user_info = res
            this.router.push('/').then(function () {
                wsShouldOpen.value = true
            })
        },
        //退出登录
        handleLogOut() {
            this.token = ''
            this.user_info = {
                id: '',
                username: '',
                nickname: '',
                status: 0,
                token: '',
                tokenHead: ' ',
                videoGroup: 0,
                autoRecord: false
            }
            wsShouldOpen.value = false
            this.router.replace('/login')
        }
    },

    persist: {
        storage: sessionStorage // 存储的类型，默认localStorage
    }
})

export default useContactsStore
