/**
 * 判断两个数组是否长度和内容一致，不能判断内嵌复杂数据的数组
 * @param a1 {Array<Number | String | Boolean>} 数组一
 * @param a2 {Array<Number | String | Boolean>} 数组二
 * @return Boolean 判断二者是否相等
 */
export function arrayMemberShallowEqual(a1: Array<any>, a2: Array<any>): boolean {
    if (a1.length !== a2.length)
        return false
    let a1LoopLength = a1.length
    let comparedA2 = [...a2]
    for (let i = 0; i < a1LoopLength; i++) {
        const indexInA2 = comparedA2.indexOf(a1[i])
        if (indexInA2 === -1) {
            return false
        }
        comparedA2.splice(indexInA2, 1)
    }
    return true
}