/**
 * 返回某个日期下的星期几的中文表达
 * @param input {Date | String | Number | null} 任何可以传入Date构造函数的数据类型
 * @return String 周日到周六的中文表达
 */
export const getWeekday = (input: Date | string | number | null) => {
    if (input === null) return "--";
    const weekArr = ["周日", "周一", "周二", "周三", "周四", "周五", "周六"];
    //格式必须是yy-mm-dd
    return weekArr[new Date(input).getDay()];
};
