/**
 * 包裹某个function，使其只能被调用一次
 * @param f {Function} 被包裹的只会被调用一次的方法
 */
export function calledOnlyOnce(f: Function) {
    let hasCalled = false
    return function () {
        if (!hasCalled) {
            hasCalled = true
            f.call(null, ...arguments)
        }
    }
}