const MAX_TRY_OUT = 30

export async function longQueryElement(selector: string, parentNode = window.document, currentTry = 1) {
    return new Promise(function (resolve) {
        if (currentTry > MAX_TRY_OUT) {
            return resolve(null)
        }
        let element = parentNode.querySelector(selector)
        if (element !== null) {
            return resolve(element)
        }
        longQueryElement(selector, parentNode,currentTry + 1)
            .then(resolve)
    })
}