/**
 * 将某个blob以fileName为名字直接下载，并且提供回调
 * @param data {Blob} 待下载的blob
 * @param fileName {String} 下载的文件名
 * @param cb {Function} 下载完成的回调，默认为空方法
 */
export function downloadStream(data: Blob, fileName: string, cb = () => {}) {
    const url = window.URL.createObjectURL(data)
    const a = document.createElement('a')
    a.download = fileName
    a.href = url
    a.style.display = 'none'
    document.body.append(a)
    a.click()
    setTimeout(function () {
        a.remove()
    }, 60000)
    if (typeof cb === 'function') {
        cb();
    }
}

export function directlyDownloadFromURL(fileUrl: string, fileName: string) {
    window.fetch(fileUrl, {
        mode: "no-cors"
    }).then(res => res.blob())
        .then(blob => downloadStream(blob, fileName))
}