import ExcelJS from "exceljs"
import {downloadStream} from "../downloadData/downloadBlob";

export type StyleCellItem = {
    value: string, // 代表数据
    color?: string, // 代表文字颜色
    bold?: boolean, // 是否为粗体
    italic?: boolean, // 是否为斜体
    underline?: boolean, // 是否有下划线
    background?: string // 背景颜色
}

/**
 * 导出带有格式化单元格的excel
 * @param data {StyleCellItem[][]} 单元格数据的二维数组，代表每一列每一行的数据
 * @param fileName {String} 导出的excel文件名
 */
export function exportAOAStyle(data: StyleCellItem[][], fileName: string) {
    const wb = new ExcelJS.Workbook();
    const sheet = wb.addWorksheet("Sheet1")
    data.forEach(function (value, index) {
        const row = sheet.getRow(index + 1)
        value.forEach(function (q, w) {
            const cell = row.getCell(w + 1)
            cell.value = q.value;
            const font = {} as any
            if (q.color) {
                font.color = {argb: q.color}
            }
            if (q.bold) {
                font.bold = q.bold
            }
            if (q.italic) {
                font.italic = q.italic
            }
            if (q.underline) {
                font.underline = q.underline
            }
            if (Object.keys(font).length > 0) {
                cell.font = font
            }
            if (q.background) {
                cell.fill = {fgColor: {argb: q.background}, type: "pattern", pattern: "solid"}
            }
        })
    })
    wb.xlsx.writeBuffer()
        .then(function (buffer: any) {
            const blob = new Blob([buffer], {type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'})
            downloadStream(blob, fileName + '.xlsx')
        })
}