//1、导入fs文件系统模块
import fs from 'fs'
import path from 'path'

const basePath = './src/assets/icons'
const files = fs.readdirSync(basePath)
const iconHtml = []
files.forEach((file) => {
    if (path.extname(file) == '.svg') {
        const fileName = file.replace('.svg', '')
        const svg = fs.readFileSync(basePath + '/' + file)
        iconHtml.push(`<div class="icon"><i>${svg}</i><span class="name">${fileName}</span></div>`)
    }
})
const html = `
        <!DOCTYPE html>
        <html>
            <head>
                <meta charset="UTF-8" />
                <meta name="viewport" content="width=device-width, initial-scale=1.0" />
            </head>
            <body>
                <div class="main">${iconHtml.join(' ')}</div>
            </body>
            <style>
            .main{
                width:1100px;
                margin:0 auto;
                padding:20px;
                display:flex;
                flex-wrap:wrap;
            }
            .icon{
                width:150px;
                padding: 10px;
                font-size: 14px;
                display:flex;
                flex-direction: column;
                justify-content: center;
                align-items: center;
            }
            svg{
                width:30px;
                height:30px;
            }
            </style>
        </html>`
fs.writeFile(basePath + '/index.html', html, function (err) {})
