/**
 * 创建唯一id，使用crypto API，返回16进制字符串
 * @param length {Number} 唯一id字符串的长度
 */
export const makeSID = function (length: number = 32) {
    if (window.crypto && window.crypto.getRandomValues !== undefined) {
        const buffer = new Uint8Array(length)
        window.crypto.getRandomValues(buffer)
        return buffer.reduce((q, w) => q + w.toString(16).padStart(2, '0'), "")
    }
    return getSID(length);
}

/**
 * 创建唯一id，使用随机数来创建，返回16进制字符串
 * @param length {Number} 唯一id字符串的长度
 */
export const getSID = function (length: number = 32) {
    let output = '';
    for (let i = 0; i < length; i++) {
        const bufferType = Math.floor(Math.random() * 3);
        switch (bufferType) {
            case 0: {
                output += String.fromCharCode(48 + Math.floor(Math.random() * 10))
            }
                break;
            case 1:{
                output += String.fromCharCode(65 + Math.floor(Math.random() * 26))
            }
                break;
            case 2: {
                output += String.fromCharCode(97 + Math.floor(Math.random() * 26))
            }
                break;
            default:break
        }
    }
    return output;
}