import {computed, ref} from "vue";
import {CallState} from "../constants/chatChannelRelated";
import {userStates} from "../states/wsStates";

export const chatChannelState = ref({
    volumeSet: [],
    voiceChatOnlySet: [],
    currentChatters: [],
    mutedUserIdSet: [],
    blinkSpotSet: [],
    chatChannelId: '',
    recordSid: "",
    recordingData: {},
    currentState: CallState.idle,
    isUnderMeetingRoom: false,
    chatRoomName: '',
    isUnderGroupChat: false,
    channelInitiator: '',
    rtcToken: "",
    screenShareId: "",
    screenCaptureShotURL: "",
    screenshotInitiatorId: "",
    screenshotURL: "",
    screenshotRecord: {},
    screenCaptureRecord: {},
    messageQueue: [],
    displayImageEditor: false
})

export const isUserHost = computed(function () {
    return userStates.value.onlineContacts.find(a=>a.fromID === userStates.value.currentUserId)?.isHost === '1'
})

export const isCurrentUserMuted = computed(function () {
    const allMutedId = chatChannelState.value.mutedUserIdSet;
    return allMutedId.includes(userStates.value.currentUserId)
})

export const allOtherChattersIdSet = computed(function () {
    return chatChannelState.value.currentChatters.filter(a=>a!==userStates.value.currentUserId)
})

export const screenShareMetaData = computed(function () {
    return {
        available: chatChannelState.value.screenShareId === '',
        byCurrentUser: chatChannelState.value.screenShareId === userStates.value.currentUserId,
        byOther: chatChannelState.value.screenShareId && chatChannelState.value.screenShareId !== userStates.value.currentUserId
    }
})

export const isScreenShotByCurrentUser = computed(() => {
    return chatChannelState.value.screenshotInitiatorId === userStates.value.currentUserId;
})

export const screenshotRecord = computed(() => Object.values(chatChannelState.value.screenshotRecord).map(a=>a.trim()).join(' '))

export const allChattersInCompany = computed(function () {
    return userStates.value.onlineContacts
        .map(a=> {
            return {
                ...a,
                isAlreadyInChat: allOtherChattersIdSet.value.includes(a.fromID),
                callable: a.callState === 'idle'
            }
        })
})