// @ts-nocheck

import {drawCanvas} from "../objs/renderBasic";
import {ComplexDrawHandleFunc} from "../types/HandlerFunc";
import {BaseDrawAttachment} from "../types/AttachmentSpecifics";
import {isDrawFromAction} from "../state/drawOperationType";

export const drawArrowsFunc: ComplexDrawHandleFunc = function (
    sx,
    sy,
    ex,
    ey,
    attachment: BaseDrawAttachment) {
    if (isDrawFromAction())
        drawCanvas()
    const ctx = attachment.ctx
    arrowDrawAct(ctx, sx, sy, ex, ey)
}

export function arrowDrawAct(ctx, sx, sy, ex, ey) {
    ctx.beginPath()
    ctx.moveTo(sx, sy)
    ctx.lineTo(ex, ey)
    const angle = Math.atan((ey - sy) / (ex - sx))
    if (ex - sx > 0) {
        ctx.lineTo(30 * Math.cos(angle + 7 * Math.PI / 6) + ex, 30 * Math.sin(angle + 7 * Math.PI / 6) + ey)
        ctx.moveTo(ex, ey)
        ctx.lineTo(30 * Math.cos(angle + 5 * Math.PI / 6) + ex, 30 * Math.sin(angle + 5 * Math.PI / 6) + ey)
    } else if (ex === sx) {
        ctx.lineTo(30 * Math.cos(4 * Math.PI / 3) + ex, 30 * Math.sin(4 * Math.PI / 3) + ey)
        ctx.moveTo(ex, ey)
        ctx.lineTo(30 * Math.cos(5 * Math.PI / 3) + ex, 30 * Math.sin(5 * Math.PI / 3) + ey)
    } else {
        ctx.lineTo(30 * Math.cos(angle + Math.PI / 6) + ex, 30 * Math.sin(angle + Math.PI / 6) + ey)
        ctx.moveTo(ex, ey)
        ctx.lineTo(30 * Math.cos(angle - Math.PI / 6) + ex, 30 * Math.sin(angle - Math.PI / 6) + ey)
    }
    ctx.stroke()
}