// @ts-nocheck

import {drawCanvas} from "../objs/renderBasic";
import {ComplexDrawHandleFunc} from "../types/HandlerFunc";
import {BaseDrawAttachment} from "../types/AttachmentSpecifics";
import {isDrawFromAction} from "../state/drawOperationType";

export const drawEllipse: ComplexDrawHandleFunc = function (
    sx,
    sy,
    ex,
    ey,
    attachment: BaseDrawAttachment
) {
    if (typeof ex === undefined || typeof ey === undefined) return
    if (isDrawFromAction())
        drawCanvas()
    const {ctx} = attachment
    ellipseDrawAct(ctx, sx, sy, ex, ey)
}

export function ellipseDrawAct(ctx, sx, sy, ex, ey) {
    ctx.beginPath()
    ctx.ellipse((ex + sx) / 2, (ey + sy) / 2, Math.abs((ex - sx) / 2), Math.abs((ey - sy) / 2), 0, 0, 2 * Math.PI)
    ctx.stroke()
}