// @ts-nocheck
import {drawCanvas, plantCanvas} from "../objs/renderBasic";
import {ComplexDrawHandleFunc} from "../types/HandlerFunc";
import {ComplexDrawAttachment, ContinuousDrawAttachment} from "../types/AttachmentSpecifics";
import {isDrawFromAction} from "../state/drawOperationType";

export const drawErase: ComplexDrawHandleFunc = function (
    sx,
    sy,
    ex,
    ey,
    attachment: ComplexDrawAttachment & ContinuousDrawAttachment) {
    if (typeof ex === 'undefined' || typeof ey === 'undefined') return
    if (isDrawFromAction())
        drawCanvas()
    const {ctx, o_ctx, points} = attachment
    points.push({ex, ey})
    eraseDrawAct(ctx, o_ctx, ex, ey)
    if (isDrawFromAction())
        plantCanvas()
}

// @ts-ignore
export function eraseDrawAct(ctx, o_ctx, ex, ey) {
    ctx.drawImage(o_ctx.canvas, ex - 6, ey - 6, 12, 12, ex - 6, ey - 6, 12, 12)
}