import {OperationRecordTyping, RawRecordItem, RecordType} from "../types/OperationRecordTyping";
import {CoreOperation} from "../objs/coreOperation";
import {drawCanvas, resetCanvas, setupCanvas} from "../objs/renderBasic";
import {ProcessCycleItem} from "../types/HandleProcessCycle";
import {setupColorConfig, setupLineWidthConfig} from "../state/operationConfigHisotry";
import {setDrawFromRecord} from "../state/drawOperationType";

export function drawOtherRecord (
    records: Array<RawRecordItem>,
    op: CoreOperation,
    typing: OperationRecordTyping,
    ctx: CanvasRenderingContext2D
) {
    setDrawFromRecord()
    drawRecord(
        records,
        op,
        typing,
        ctx
    )
    drawRecord(
        // @ts-ignore
        op.record?.getInternalState().rawRecord,
        op,
        op.record?.getInternalState().operationRecordTypeSet,
        ctx,
        true
    )
}

export function drawRecord (
    records: Array<RawRecordItem>,
    op: CoreOperation,
    typing: OperationRecordTyping,
    ctx: CanvasRenderingContext2D,
    keepCurrentScratch = false) {
    if (!keepCurrentScratch) {
        resetCanvas()
        drawCanvas()
    }
    const operationInternalState = op.getInternalState()
    setupCanvas(ctx)
    records.forEach(({name, record}) => {
        const operationTyping = Reflect.get(typing, name) as RecordType
        if (operationTyping === RecordType.Immediate) {
            const foundedImmediate = operationInternalState.immediatePs.find(e => e.name === name) as ProcessCycleItem
            return foundedImmediate.func.call(null)
        }
        if (operationTyping === RecordType.Continuous) {
            const foundedStamp = Reflect.get(operationInternalState.stampProcess, name) as ProcessCycleItem
            foundedStamp.attachment.points.length = 0
            const continuousPoints = (record as Array<{ ex: number, ey: number }>)
            continuousPoints.forEach(point => {
                foundedStamp.func.call(null, undefined, undefined, point.ex, point.ey, foundedStamp.attachment)
            })
            foundedStamp.attachment.points.length = 0
            return
        }
        // 目前所有索引类记录只涉及到canvas的图像设置，并且操作均为Immediate
        if (operationTyping === RecordType.Index) {
            // 如果是回溯，则需要调整到前一个同类型操作
            const foundedImmediate = operationInternalState.immediatePs.find(e => e.name === name) as ProcessCycleItem
            if (name === 'colorConfig') {
                setupColorConfig(record)
                foundedImmediate.func.call(null, false)
            } else if (name === 'lineWidth') {
                setupLineWidthConfig(record)
                foundedImmediate.func.call(null, false)
            }
            return
        }
        if (operationTyping === RecordType.VectorPayload) {
            const foundedStamp = Reflect.get(operationInternalState.stampProcess, name) as ProcessCycleItem
            foundedStamp.attachment.payload = record.payload
            return foundedStamp.func.call(null, record.sx, record.sy, record.ex, record.ey, foundedStamp.attachment)
        }
        if (operationTyping === RecordType.Vector) {
            const foundedStamp = Reflect.get(operationInternalState.stampProcess, name) as ProcessCycleItem
            foundedStamp.func.call(null, record.sx, record.sy, record.ex, record.ey, foundedStamp.attachment)
        }
    })
}