import {Ref, ref} from "vue"
import {ExtendTextInputWidgetInputProps, OptionalTypeInputWidgetProps} from "../types/TextInputWidgetSpecific";

export const currentActionWidgetId = ref("") as Ref<string>

export const setCurrentActionWidgetId = (v: string) => {
    currentActionWidgetId.value = v
}

export const wholeTextInputWidgets = ref([]) as Ref<Array<ExtendTextInputWidgetInputProps>>

export const addNewWidget = (v: ExtendTextInputWidgetInputProps) => {
    wholeTextInputWidgets.value.push(v)
}

export const removeWidget = (v: string) => {
    wholeTextInputWidgets.value = wholeTextInputWidgets.value.filter(i => i.id !== v)
}

export const updateCurrentOperatingWidget = (v: OptionalTypeInputWidgetProps) => {
    const operatingWidget = wholeTextInputWidgets.value.find(i=>i.id === v.id)
    if (typeof operatingWidget !== undefined) {
        Object.assign(operatingWidget, v)
    }
}

// 当有新组件生成之时，删除所有内容为空的输入组件
export const pruneWidget = () => {
    wholeTextInputWidgets.value = wholeTextInputWidgets.value.filter(i => i.text.length > 0)
}

export const clearAll = () => {
    wholeTextInputWidgets.value.length = 0
    currentActionWidgetId.value = ""
}