export const deepClone = (o: any): any => {
    if (Array.isArray(o)) {
        let cloned: Array<any> = []
        o.forEach(item => {
            cloned.push(deepClone(item))
        })
        return cloned
    }
    if (typeof o === 'object' && o !== null) {
        let cloned: any = {}
        for (const [k, v] of Object.entries(o)) {
            cloned[k] = deepClone(v)
        }
        return cloned
    }
    return o
}

export const unifyArray = (o: Array<any>): Array<any> => {
    let clonedArray: Array<any> = []
    o.forEach(item => {
        if (clonedArray.find(pushedItem => JSON.stringify(pushedItem) === JSON.stringify(item)) === undefined) {
            clonedArray.push(item)
        }
    })
    return clonedArray
}