export default {
    path: 'remote',
    component: () => import('@/views/remote/index.vue'),
    name: 'Remote',
    meta: { title: '远程模块', locale: 'menu.remote', hideInMenu: false },
    redirect: { name: 'Contacts' },
    children: [
        {
            path: '/contacts',
            component: () => import(/* webpackChunkName: "Contacts" */ '@/views/remote/contacts/index.vue'),
            name: 'Contacts',
            meta: { title: '联系人', locale: 'menu.remote.contacts', hideInMenu: false }
        },
        {
            path: '/videoCall',
            component: () => import(/* webpackChunkName: "Resource" */ '@/views/remote/videoCall/index.vue'),
            name: 'VideoCall',
            meta: { title: '视频通话', hideInMenu: true }
        },
        {
            path: '/events',
            component: () => import(/* webpackChunkName: "Events" */ '@/views/remote/events/index.vue'),
            name: 'Events',
            meta: { title: '进行中的事件', locale: 'menu.remote.events', hideInMenu: true }
        },
        {
            path: '/experience',
            component: () => import(/* webpackChunkName: "Experience" */ '@/views/remote/experience/index.vue'),
            name: 'Experience',
            meta: { title: '经验库', locale: 'menu.remote.experience', hideInMenu: true }
        },
        {
            path: '/resource',
            component: () => import(/* webpackChunkName: "Resource" */ '@/views/remote/resource/index.vue'),
            name: 'Resource',
            meta: { title: '资源库', locale: 'menu.remote.resource', hideInMenu: true }
        }
    ]
}
