// @ts-nocheck
/**
 * 保证在ms范围内不会多次调用方法，只会再最后一次调用结束后的ms后call
 * @param f {Function} 待处理的方法
 * @param ms {Number} 防抖动的时间，单位为毫秒
 * @param isAsync {Boolean} 该方法是否为异步
 */
export function delayFuncCall(f: Function, ms: number, isAsync = false): Function {
    let newestArguments: any[] = []
    let lastTimer: number
    return function () {
        newestArguments = arguments
        clearTimeout(lastTimer)
        if (!isAsync) {
            lastTimer = setTimeout(function () {
                f.call(null, ...newestArguments)
            }, ms)
        } else {
            lastTimer = setTimeout(async function () {
                await f.call(null, ...newestArguments)
            }, ms)
        }
    }
}