import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import { resolve } from 'path'
import Components from 'unplugin-vue-components/vite'
import AutoImport from 'unplugin-auto-import/vite'
import { ArcoResolver } from 'unplugin-vue-components/resolvers'
import { vitePluginForArco } from '@arco-plugins/vite-vue'
import viteCompression from 'vite-plugin-compression'
import { createSvgIconsPlugin } from 'vite-plugin-svg-icons'

import path from 'path'

// @ts-ignore
import { arcoUiConfig } from './src/configs/arco.ui.config.ts'
// @ts-ignore
import appDefine from './project.app.config'

// https://vitejs.dev/config/
export default defineConfig({
    css: {
        preprocessorOptions: {
            less: {
                modifyVars: arcoUiConfig, // 定制less变量
                javascriptEnabled: true
            }
        }
    },
    plugins: [
        vue(),
        vitePluginForArco(),
        AutoImport({
            imports: ['vue', 'vue-router'],
            dts: 'src/auto-import.d.ts',
            resolvers: [ArcoResolver()],
            exclude: ['anyremote/agora/AgoraRTC_N-4.19.1.js']
        }),
        Components({
            // 自动导入的组件位置，默认是src/components
            dirs: ['src/components'],
            resolvers: [
                ArcoResolver({
                    importStyle: 'less',
                    resolveIcons: true,
                    sideEffect: true
                })
            ],
            dts: false
        }),
        viteCompression({
            disable: !appDefine.enableGZip, // 是否禁用
            deleteOriginFile: true // 删除源文件，删除后nginx没有开启压缩的情况下，就不可以访问
        }),
        createSvgIconsPlugin({
            // Specify the icon folder to be cached
            iconDirs: [path.resolve(process.cwd(), 'src/assets/icons')],
            // Specify symbolId format
            symbolId: 'icon-[dir]-[name]'
        })
    ],
    resolve: {
        alias: {
            '@': resolve('src'),
            AnyR: resolve(__dirname, 'anyremote')
        }
    },
    base: './', // 打包路径
    server: {
        port: 3000, // 启动端口
        open: true, // 自动打开
        cors: true // 跨域
    },
    optimizeDeps: {
        exclude: ['anyremote/agora/AgoraRTC_N-4.19.1.js']
    }
})
