// vite.config.ts
import { defineConfig } from "file:///D:/WorkProjects/standalone-anyremote/node_modules/vite/dist/node/index.js";
import vue from "file:///D:/WorkProjects/standalone-anyremote/node_modules/@vitejs/plugin-vue/dist/index.mjs";
import { resolve } from "path";
import Components from "file:///D:/WorkProjects/standalone-anyremote/node_modules/unplugin-vue-components/dist/vite.js";
import AutoImport from "file:///D:/WorkProjects/standalone-anyremote/node_modules/unplugin-auto-import/dist/vite.js";
import { ArcoResolver } from "file:///D:/WorkProjects/standalone-anyremote/node_modules/unplugin-vue-components/dist/resolvers.js";
import { vitePluginForArco } from "file:///D:/WorkProjects/standalone-anyremote/node_modules/@arco-plugins/vite-vue/lib/index.js";
import viteCompression from "file:///D:/WorkProjects/standalone-anyremote/node_modules/vite-plugin-compression/dist/index.mjs";
import { createSvgIconsPlugin } from "file:///D:/WorkProjects/standalone-anyremote/node_modules/vite-plugin-svg-icons/dist/index.mjs";
import path from "path";

// project.ui.config.ts
import { ref } from "file:///D:/WorkProjects/standalone-anyremote/node_modules/vue/index.mjs";
var activedTheme = ref("dark");
var project_ui_config_default = {
  // 定义项目配色主色
  colors: {
    // 亮色主题 ===================
    // 主色
    primary: "#165dff",
    // 主色
    primaryHover: "#4080ff",
    // 主色鼠标移上色
    primaryPressed: "#0e42d2",
    // 主色按下色
    primaryActivated: "#165dff",
    // 主色激活色
    primaryDisable: "#94bfff",
    // 主色禁用色
    // 背景色
    themeBg1: "#ffffff",
    // 背景色
    themeBg2: "#ffffff",
    // 比上面浅一点
    themeBg3: "#f7f8fa",
    // 比上面浅一点
    themeBg4: "#ffffff",
    // 比上面浅一点
    themeBg5: "#ffffff",
    // 比上面浅一点
    // 文字色
    themeText1: "#1D2129",
    // 正常文字
    themeText2: "#4E5969",
    // 比上面浅一点
    themeText3: "#86909C",
    // 比上面浅一点
    themeText4: "#C9CDD4",
    // 比上面浅一点
    themeText5: "#eeeeee",
    // 比上面浅一点
    // 填充颜色
    themeFill1: "rgb(var(--gray-1))",
    // 正常填充
    themeFill2: "rgb(var(--gray-2))",
    // 比上面浅一点
    themeFill3: "rgb(var(--gray-3))",
    // 比上面浅一点
    themeFill4: "rgb(var(--gray-4))",
    // 比上面浅一点
    // 深色主题 ===================
    // 主色
    darkPrimary: "#3c7eff",
    // 主色
    darkPrimaryHover: "#306fff",
    // 主色鼠标移上色
    darkPrimaryPressed: "#689fff",
    // 主色按下色
    darkPrimaryActivated: "#1d4dd2",
    // 主色激活色
    darkPrimaryDisable: "#0e32a6",
    // 主色禁用色
    // 背景色
    darkThemeBg1: "#17171A",
    // 背景色
    darkThemeBg2: "#232324",
    // 比上面浅一点
    darkThemeBg3: "#2A2A2B",
    // 比上面浅一点
    darkThemeBg4: "#313132",
    // 比上面浅一点
    darkThemeBg5: "#373739",
    // 比上面浅一点
    // 文字色
    darkThemeText1: "rgba(255, 255, 255, .9)",
    // 正常文字
    darkThemeText2: "rgba(255, 255, 255, .7)",
    // 比上面浅一点
    darkThemeText3: "rgba(255, 255, 255, .5)",
    // 比上面浅一点
    darkThemeText4: "rgba(255, 255, 255, .3)",
    // 比上面浅一点
    darkThemeText5: "#666666",
    // 比上面浅一点
    // 填充颜色
    darkThemeFill1: "rgba(255, 255, 255, .04)",
    // 正常填充
    darkThemeFill2: "rgba(255, 255, 255, .08)",
    // 比上面浅一点
    darkThemeFill3: "rgba(255, 255, 255, .12)",
    // 比上面浅一点
    darkThemeFill4: "rgba(255, 255, 255, .16)"
    // 比上面浅一点
  },
  // 定义间距
  spacing: {
    xxs: "4px",
    xs: "8px",
    sm: "12px",
    md: "18px",
    lg: "24px",
    xl: "32px",
    x2l: "48px",
    x3l: "64px",
    x4l: "80px",
    x5l: "96px",
    x6l: "120px",
    x7l: "150px",
    x8l: "180px",
    x9l: "210px"
  },
  // 定义圆角
  borderRadius: {
    xs: "2px",
    sm: "4px",
    md: "8px",
    lg: "12px",
    xl: "16px"
  },
  // 定义圆角宽
  borderWidth: {
    xs: "1px",
    sm: "2px",
    md: "3px",
    lg: "4px",
    xl: "5px"
  }
};

// src/configs/arco.ui.config.ts
var arcoUiConfig = {
  // 白底主色 ==================
  "primary-7": project_ui_config_default.colors.primaryPressed,
  "primary-6": project_ui_config_default.colors.primary,
  "primary-5": project_ui_config_default.colors.primaryHover,
  "primary-4": project_ui_config_default.colors.primaryActivated,
  "primary-3": project_ui_config_default.colors.primaryDisable,
  "primary-2": project_ui_config_default.colors.primaryDisable,
  "primary-1": project_ui_config_default.colors.primaryDisable,
  "color-bg-1": project_ui_config_default.colors.themeBg1,
  "color-bg-2": project_ui_config_default.colors.themeBg2,
  "color-bg-3": project_ui_config_default.colors.themeBg3,
  "color-bg-4": project_ui_config_default.colors.themeBg4,
  "color-bg-5": project_ui_config_default.colors.themeBg5,
  "color-text-1": project_ui_config_default.colors.themeText1,
  "color-text-2": project_ui_config_default.colors.themeText2,
  "color-text-3": project_ui_config_default.colors.themeText3,
  "color-text-4": project_ui_config_default.colors.themeText4,
  // 深底主色 ==================
  "dark-primary-7": project_ui_config_default.colors.darkPrimaryPressed,
  "dark-primary-6": project_ui_config_default.colors.darkPrimary,
  "dark-primary-5": project_ui_config_default.colors.darkPrimaryHover,
  "dark-primary-4": project_ui_config_default.colors.darkPrimaryActivated,
  "dark-primary-3": project_ui_config_default.colors.darkPrimaryDisable,
  "dark-primary-2": project_ui_config_default.colors.darkPrimaryDisable,
  "dark-primary-1": project_ui_config_default.colors.darkPrimaryDisable,
  "dark-color-bg-1": project_ui_config_default.colors.darkThemeBg1,
  "dark-color-bg-2": project_ui_config_default.colors.darkThemeBg2,
  "dark-color-bg-3": project_ui_config_default.colors.darkThemeBg3,
  "dark-color-bg-4": project_ui_config_default.colors.darkThemeBg4,
  "dark-color-bg-5": project_ui_config_default.colors.darkThemeBg5,
  "dark-color-text-1": project_ui_config_default.colors.darkThemeText1,
  "dark-color-text-2": project_ui_config_default.colors.darkThemeText2,
  "dark-color-text-3": project_ui_config_default.colors.darkThemeText3,
  "dark-color-text-4": project_ui_config_default.colors.darkThemeText4,
  // 边框宽度 =================
  "border-1": project_ui_config_default.borderWidth.xs,
  "border-2": project_ui_config_default.borderWidth.sm,
  "border-3": project_ui_config_default.borderWidth.md,
  // 边框圆角 ================
  "border-radius-small": project_ui_config_default.borderRadius.sm,
  "border-radius-medium": project_ui_config_default.borderRadius.md,
  "border-radius-large": project_ui_config_default.borderRadius.lg
};

// project.app.config.ts
var project_app_config_default = {
  // App配置 ==========
  baseTitle: "Vue3\u9879\u76EE",
  // 基础标题
  enableGZip: false
  // 是否开启gzip压缩
};
var ApiConfig = {
  // 本地存储token的key
  API_TOKEN_KEY: "token",
  // 是否开发环境
  IS_DEVMODE: true,
  // API服务器超时设置.
  API_TIMEOUT: 30 * 1e3,
  // 接口服务器地址.
  DEV_API_URL: "https://ifar.test.com:440",
  PROD_API_URL: "https://www.insightbridge.com.cn",
  // Mockt等待延时时间
  MOCK_DELAY: 1e3
};
var API_URL = ApiConfig.IS_DEVMODE ? ApiConfig.DEV_API_URL : ApiConfig.PROD_API_URL;

// vite.config.ts
var __vite_injected_original_dirname = "D:\\WorkProjects\\standalone-anyremote";
var vite_config_default = defineConfig({
  css: {
    preprocessorOptions: {
      less: {
        modifyVars: arcoUiConfig,
        // 定制less变量
        javascriptEnabled: true
      }
    }
  },
  plugins: [
    vue(),
    vitePluginForArco(),
    AutoImport({
      imports: ["vue", "vue-router"],
      dts: "src/auto-import.d.ts",
      resolvers: [ArcoResolver()],
      exclude: ["anyremote/agora/AgoraRTC_N-4.19.1.js"]
    }),
    Components({
      // 自动导入的组件位置，默认是src/components
      dirs: ["src/components"],
      resolvers: [
        ArcoResolver({
          importStyle: "less",
          resolveIcons: true,
          sideEffect: true
        })
      ],
      dts: false
    }),
    viteCompression({
      disable: !project_app_config_default.enableGZip,
      // 是否禁用
      deleteOriginFile: true
      // 删除源文件，删除后nginx没有开启压缩的情况下，就不可以访问
    }),
    createSvgIconsPlugin({
      // Specify the icon folder to be cached
      iconDirs: [path.resolve(process.cwd(), "src/assets/icons")],
      // Specify symbolId format
      symbolId: "icon-[dir]-[name]"
    })
  ],
  resolve: {
    alias: {
      "@": resolve("src"),
      AnyR: resolve(__vite_injected_original_dirname, "anyremote")
    }
  },
  base: "./",
  // 打包路径
  server: {
    port: 3e3,
    // 启动端口
    open: true,
    // 自动打开
    cors: true
    // 跨域
  },
  optimizeDeps: {
    exclude: ["anyremote/agora/AgoraRTC_N-4.19.1.js"]
  }
});
export {
  vite_config_default as default
};
//# sourceMappingURL=data:application/json;base64,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
