import {chatChannelState} from "../states/chatChannelStates";
import {webrtcStates} from "../states/webrtcStates";
import {userStates} from "../states/wsStates";

export class Agora {

    notUploadLog = false;
    logLevel = 1;
    codec = '';
    mode = '';
    appId = '';
    localPlayerId = '';
    remotePlayerPrefix = ''
    data = {
        uid: null,
        localTracks: {
            videoTrack: undefined,
            audioTrack: undefined,
        },
    }
    AgoraClient = null
    localAp = null

    constructor(options) {
        this.notUploadLog = options.notUploadLog
        this.logLevel = options.logLevel
        this.codec = options.codec
        this.mode = options.mode
        this.appId = options.appId
        this.localPlayerId = options.localPlayerId
        this.remotePlayerPrefix = options.remotePlayerPrefix
        this.localAp = options.localAp
    }

    async #subscribe(user, mediaType) {
        await this.AgoraClient.subscribe(user, mediaType);
        const allUsers = userStates.value.onlineContacts
        const foundUser = allUsers.find(i => i.fromID.toString() === user.uid.toString());
        console.log('开始订阅远端用户', user, mediaType, foundUser);
        const remoteUserIdInThisUser = this.remotePlayerPrefix + user.uid;
        if (mediaType === 'video') {
            user?.videoTrack?.play(remoteUserIdInThisUser);
        }
        if (mediaType === 'audio') {
            user?.audioTrack?.play();
        }
    }

    #clearTracks() {
        for (const v of Object.values(this.data.localTracks)) {
            if (v && !v._isClosed) {
                v.stop();
                v.close()
            }
        }
        this.data.localTracks = {
            videoTrack: undefined,
            audioTrack: undefined,
        };
    }

    async join(channelId, token = null, uid = null) {
        let canProceed = true;
        this.data.uid = uid ? uid.toString() : ''
        const {isMicroAttached, isCameraAttached} = webrtcStates.value
        console.log('创建条件', isMicroAttached, isCameraAttached, channelId, token, uid, this.appId);
        if (this.localAp) {
            this.AgoraClient.setLocalAccessPointsV2(this.localAp);
        }
        try {
            if (isMicroAttached) {
                this.data.localTracks.audioTrack = await AgoraRTC.createMicrophoneAudioTrack();
            }
            if (isCameraAttached) {
                this.data.localTracks.videoTrack = await AgoraRTC.createCameraVideoTrack();
                webrtcStates.value.currentUsingCameraName = this.data.localTracks.videoTrack._deviceName;
            }
        } catch (e) {
            console.log('加入频道出现错误', e)
            canProceed = false;
            this.#clearTracks()
        }
        console.log('tracks here', this.data.localTracks);
        if (!this.data.localTracks.videoTrack || !this.data.localTracks.audioTrack) {
            alert('创建音视频轨道失败！离开会议！')
            await this.leave()
            return;
        }
        this.AgoraClient.enableAudioVolumeIndicator();
        await this.AgoraClient.join(this.appId, channelId, token || null, Number(uid));
        if (canProceed) {
            console.log('创建音视频轨道成功！', this.data.localTracks)
            if (this.data.localTracks.videoTrack) {
                this.data.localTracks.videoTrack.play(this.localPlayerId, {fit: 'contain'})
            }
            console.log('开始播放本地媒体')
            await this.AgoraClient.publish(Object.values(this.data.localTracks));
            console.log('成功发布媒体')
        }
    }

    currentUserToggleMute(v) {
        if (this.data.localTracks.audioTrack) {
            this.data.localTracks.audioTrack.setMuted(v);
        }
    }

    async toggleScreenShare(v, endFunc, failedFunc, pageHideFunc) {
        const videoTrack = this.AgoraClient.localTracks.find(i => i.trackMediaType === 'video');
        if (videoTrack) {
            videoTrack.stop();
            const currentVideoTrack = this.AgoraClient.localTracks.find(i => i._ID === videoTrack._ID);
            await this.AgoraClient.unpublish(currentVideoTrack);
            webrtcStates.value.currentUsingCameraName = '';
            videoTrack.close();
        }
        if (v) {
            try {
                const screenAudioTrack = await AgoraRTC.createScreenVideoTrack({}, 'disable');
                screenAudioTrack.play(this.localPlayerId, {fit: 'contain'});
                await this.AgoraClient.publish(screenAudioTrack);
                webrtcStates.value.currentUsingCameraName = '';
                screenAudioTrack.on('track-ended', async () => {
                    await this.toggleScreenShare(false, endFunc, failedFunc, pageHideFunc)
                    endFunc()
                })
                if (!document.hasFocus()) {
                    if (typeof pageHideFunc === 'function') {
                        pageHideFunc()
                    }
                }
            } catch (e) {
                console.log('出现错误', e);
                if (typeof failedFunc === 'function') {
                    failedFunc()
                }
                await this.toggleScreenShare(false, endFunc, failedFunc, pageHideFunc)
            }
        } else {
            this.data.localTracks.videoTrack = await AgoraRTC.createCameraVideoTrack();
            webrtcStates.value.currentUsingCameraName = this.data.localTracks.videoTrack._deviceName;
            this.data.localTracks.videoTrack.play(this.localPlayerId, {fit: 'contain'})
            await this.AgoraClient.publish(this.data.localTracks.videoTrack);
        }
    }

    async currentUserToggleVoiceChatOnly(v) {
        if (v) {
            const videoTrack = this.AgoraClient.localTracks.find(i => i.trackMediaType === 'video');
            videoTrack.stop();
            await this.AgoraClient.unpublish(videoTrack);
            webrtcStates.value.currentUsingCameraName = '';
            videoTrack.close();
            this.data.localTracks.videoTrack = undefined;
        } else {
            this.data.localTracks.videoTrack = await AgoraRTC.createCameraVideoTrack();
            webrtcStates.value.currentUsingCameraName = this.data.localTracks.videoTrack._deviceName;
            await this.AgoraClient.publish(this.data.localTracks.videoTrack);
            this.data.localTracks.videoTrack.play(this.localPlayerId, {fit: 'contain'})
        }
    }

    async leave() {
        this.#clearTracks()
        await this.AgoraClient.leave();
        console.log('成功离开频道')
    }

    async forceReplay(id, vid) {
        const foundUser = this.AgoraClient.remoteUsers.find(i => i.uid.toString() === id.toString());
        console.log('强制播放用户', foundUser)
        await foundUser?.videoTrack?.play(vid);
    }

    async switchDeviceForCamera(id) {
        if (typeof this.data.localTracks.videoTrack !== void 0) {
            await this.data.localTracks.videoTrack.setDevice(id);
            webrtcStates.value.currentUsingCameraName = webrtcStates.value.cameraDeviceSet.find(a => a.deviceId === id)?.label
        }
    }

    async preload() {
        return new Promise((resolve, reject) => {
            console.trace()
            import("./AgoraRTC_N-4.19.1.js?url")
                .then((url) => {
                    console.log('the url here', url)
                    const s = document.createElement('script');
                    s.src = url.default;
                    s.onerror = reject;
                    s.onload = () => {
                        if (this.notUploadLog) {
                            AgoraRTC.disableLogUpload();
                        }
                        AgoraRTC.setLogLevel(this.logLevel);
                        this.AgoraClient = AgoraRTC.createClient({mode: this.mode, codec: this.codec});
                        this.AgoraClient.on('volume-indicator', function (volumes) {
                            chatChannelState.value.volumeSet = volumes;
                        })
                        console.log('client 已经创建', this.AgoraClient)
                        window.navigator.mediaDevices.enumerateDevices()
                            .then(function (info) {
                                const wholeCameraSet = info.filter(a => a.kind === 'videoinput');
                                webrtcStates.value.cameraDeviceSet = wholeCameraSet;
                                webrtcStates.value.isCameraAttached = wholeCameraSet.length > 0
                                webrtcStates.value.isMicroAttached = info.filter(a => a.kind === 'audioinput').length > 0;
                                console.log('当前设备状况', info, chatChannelState.value)
                            })
                        AgoraRTC.onCameraChanged = function () {
                            window.navigator.mediaDevices.enumerateDevices()
                                .then(function (info) {
                                    const wholeCameraSet = info.filter(a => a.kind === 'videoinput');
                                    webrtcStates.value.cameraDeviceSet = wholeCameraSet;
                                    webrtcStates.value.isCameraAttached = wholeCameraSet.length > 0
                                })
                        }
                        AgoraRTC.onMicrophoneChanged = function () {
                            window.navigator.mediaDevices.enumerateDevices()
                                .then(function (info) {
                                    webrtcStates.value.isMicroAttached = info.filter(a => a.kind === 'audioinput').length > 0;
                                })
                        }
                        this.AgoraClient.on('user-joined', (user) => {
                            const uidS = user.uid.toString()
                            const targetUser = userStates.value.onlineContacts.find(a => a.fromID.toString() === uidS);
                            console.log('在线用户加入了频道', targetUser)
                            targetUser.callState = 'calling'
                        })
                        this.AgoraClient.on('user-left', (user) => {
                            const uidS = user.uid.toString()
                            const targetUser = userStates.value.onlineContacts.find(a => a.fromID.toString() === uidS);
                            console.log('在线用户离开了频道', targetUser)
                        })
                        this.AgoraClient.on('user-published', (user, mediaType) => {
                            console.log('检测到远程用户发布媒体', user, mediaType);
                            if (user.uid.toString() !== this.data.uid.toString()) {
                                this.#subscribe(user, mediaType)
                            }
                            if (mediaType === 'audio') {
                                chatChannelState.value.mutedUserIdSet = chatChannelState.value.mutedUserIdSet.filter(i => i !== user.uid);
                            }
                        })
                        this.AgoraClient.on('user-unpublished', async (user, mediaType) => {
                            console.log('检测到远程用户取消发布媒体', user, mediaType);
                            if (user.uid.toString() !== this.data.uid.toString()) {
                                await this.AgoraClient.unsubscribe(user, mediaType);
                            }
                            if (mediaType === 'audio') {
                                if (!chatChannelState.value.mutedUserIdSet.includes(user.uid)) {
                                    chatChannelState.value.mutedUserIdSet.push(user.uid);
                                }
                                user?.audioTrack?.stop()
                            }
                            if (mediaType === 'video') {
                                user?.videoTrack?.stop()
                            }
                        })
                        this.AgoraClient.on('network-quality', quality => {
                            if (chatChannelState.value.currentChatters.length === 0) {
                                return;
                            }
                            const {downlinkNetworkQuality: down, uplinkNetworkQuality: up} = quality
                            webrtcStates.value.networkQuality = {
                                down, up
                            };
                        })
                        resolve();
                    }
                    document.body.append(s);
                })
        })
    }

}