import { ref } from 'vue'

// 激活主题色：dark, light
export const activedTheme = ref('dark')

// UI配置
export default {
    // 定义项目配色主色
    colors: {
        // 亮色主题 ===================
        // 主色
        primary: '#165dff', // 主色
        primaryHover: '#4080ff', // 主色鼠标移上色
        primaryPressed: '#0e42d2', // 主色按下色
        primaryActivated: '#165dff', // 主色激活色
        primaryDisable: '#94bfff', // 主色禁用色
        // 背景色
        themeBg1: '#ffffff', // 背景色
        themeBg2: '#ffffff', // 比上面浅一点
        themeBg3: '#f7f8fa', // 比上面浅一点
        themeBg4: '#ffffff', // 比上面浅一点
        themeBg5: '#ffffff', // 比上面浅一点
        // 文字色
        themeText1: '#1D2129', // 正常文字
        themeText2: '#4E5969', // 比上面浅一点
        themeText3: '#86909C', // 比上面浅一点
        themeText4: '#C9CDD4', // 比上面浅一点
        themeText5: '#eeeeee', // 比上面浅一点
        // 填充颜色
        themeFill1: 'rgb(var(--gray-1))', // 正常填充
        themeFill2: 'rgb(var(--gray-2))', // 比上面浅一点
        themeFill3: 'rgb(var(--gray-3))', // 比上面浅一点
        themeFill4: 'rgb(var(--gray-4))', // 比上面浅一点
        // 深色主题 ===================
        // 主色
        darkPrimary: '#3c7eff', // 主色
        darkPrimaryHover: '#306fff', // 主色鼠标移上色
        darkPrimaryPressed: '#689fff', // 主色按下色
        darkPrimaryActivated: '#1d4dd2', // 主色激活色
        darkPrimaryDisable: '#0e32a6', // 主色禁用色
        // 背景色
        darkThemeBg1: '#17171A', // 背景色
        darkThemeBg2: '#232324', // 比上面浅一点
        darkThemeBg3: '#2A2A2B', // 比上面浅一点
        darkThemeBg4: '#313132', // 比上面浅一点
        darkThemeBg5: '#373739', // 比上面浅一点
        // 文字色
        darkThemeText1: 'rgba(255, 255, 255, .9)', // 正常文字
        darkThemeText2: 'rgba(255, 255, 255, .7)', // 比上面浅一点
        darkThemeText3: 'rgba(255, 255, 255, .5)', // 比上面浅一点
        darkThemeText4: 'rgba(255, 255, 255, .3)', // 比上面浅一点
        darkThemeText5: '#666666', // 比上面浅一点
        // 填充颜色
        darkThemeFill1: 'rgba(255, 255, 255, .04)', // 正常填充
        darkThemeFill2: 'rgba(255, 255, 255, .08)', // 比上面浅一点
        darkThemeFill3: 'rgba(255, 255, 255, .12)', // 比上面浅一点
        darkThemeFill4: 'rgba(255, 255, 255, .16)' // 比上面浅一点
    },
    // 定义间距
    spacing: {
        xxs: '4px',
        xs: '8px',
        sm: '12px',
        md: '18px',
        lg: '24px',
        xl: '32px',
        x2l: '48px',
        x3l: '64px',
        x4l: '80px',
        x5l: '96px',
        x6l: '120px',
        x7l: '150px',
        x8l: '180px',
        x9l: '210px'
    },
    // 定义圆角
    borderRadius: {
        xs: '2px',
        sm: '4px',
        md: '8px',
        lg: '12px',
        xl: '16px'
    },
    // 定义圆角宽
    borderWidth: {
        xs: '1px',
        sm: '2px',
        md: '3px',
        lg: '4px',
        xl: '5px'
    }
}
