import projectUiConfig from '../../project.ui.config'

// 改变ArcoUI框架的主题
export function changeArcoTheme(themeName: string) {
    if (themeName === 'dark') {
        document.body.setAttribute('arco-theme', themeName)
    } else {
        document.body.removeAttribute('arco-theme')
    }
}

// Arco的变量设置
export const arcoUiConfig = {
    // 白底主色 ==================
    'primary-7': projectUiConfig.colors.primaryPressed,
    'primary-6': projectUiConfig.colors.primary,
    'primary-5': projectUiConfig.colors.primaryHover,
    'primary-4': projectUiConfig.colors.primaryActivated,
    'primary-3': projectUiConfig.colors.primaryDisable,
    'primary-2': projectUiConfig.colors.primaryDisable,
    'primary-1': projectUiConfig.colors.primaryDisable,
    'color-bg-1': projectUiConfig.colors.themeBg1,
    'color-bg-2': projectUiConfig.colors.themeBg2,
    'color-bg-3': projectUiConfig.colors.themeBg3,
    'color-bg-4': projectUiConfig.colors.themeBg4,
    'color-bg-5': projectUiConfig.colors.themeBg5,
    'color-text-1': projectUiConfig.colors.themeText1,
    'color-text-2': projectUiConfig.colors.themeText2,
    'color-text-3': projectUiConfig.colors.themeText3,
    'color-text-4': projectUiConfig.colors.themeText4,
    // 深底主色 ==================
    'dark-primary-7': projectUiConfig.colors.darkPrimaryPressed,
    'dark-primary-6': projectUiConfig.colors.darkPrimary,
    'dark-primary-5': projectUiConfig.colors.darkPrimaryHover,
    'dark-primary-4': projectUiConfig.colors.darkPrimaryActivated,
    'dark-primary-3': projectUiConfig.colors.darkPrimaryDisable,
    'dark-primary-2': projectUiConfig.colors.darkPrimaryDisable,
    'dark-primary-1': projectUiConfig.colors.darkPrimaryDisable,
    'dark-color-bg-1': projectUiConfig.colors.darkThemeBg1,
    'dark-color-bg-2': projectUiConfig.colors.darkThemeBg2,
    'dark-color-bg-3': projectUiConfig.colors.darkThemeBg3,
    'dark-color-bg-4': projectUiConfig.colors.darkThemeBg4,
    'dark-color-bg-5': projectUiConfig.colors.darkThemeBg5,
    'dark-color-text-1': projectUiConfig.colors.darkThemeText1,
    'dark-color-text-2': projectUiConfig.colors.darkThemeText2,
    'dark-color-text-3': projectUiConfig.colors.darkThemeText3,
    'dark-color-text-4': projectUiConfig.colors.darkThemeText4,
    // 边框宽度 =================
    'border-1': projectUiConfig.borderWidth.xs,
    'border-2': projectUiConfig.borderWidth.sm,
    'border-3': projectUiConfig.borderWidth.md,
    // 边框圆角 ================
    'border-radius-small': projectUiConfig.borderRadius.sm,
    'border-radius-medium': projectUiConfig.borderRadius.md,
    'border-radius-large': projectUiConfig.borderRadius.lg
}
