/**
 * 在异步操作中休息若干毫秒
 * @param expiredTime {Number} 休息的时间，单位为毫秒
 * @return Promise<void> 无返回值
 */

export function sleepInAsyncFunc(expiredTime: number): Promise<void> {
    return new Promise(function (r) {
        setTimeout(function () {
            r()
        }, expiredTime)
    })
}