/*
 * Copyright (c) $today.year-$today.month-13
 * Created by: qlintonger xeno
 * Email: 1983115293@qq.com
 */

/**
 * 深克隆方法，建议不要使用JSON类操作，而使用本方法
 * @param obj {*} 任何合法数据类型
 */
export function deepCopyObject(obj: any): any {
    if (Array.isArray(obj)) {
        let preCloned = []
        for (const item of obj) {
            preCloned.push(deepCopyObject(item))
        }
        return preCloned
    }
    if (typeof obj === 'object' && obj !== null) {
        let preCloned = {}
        for (const k of Object.keys(obj)) {
            // @ts-ignore
            preCloned[k] = deepCopyObject(obj[k])
        }
        return preCloned
    }
    return obj
}
